<div class="custom-timeline">
    <?php if( have_rows('timeline') ) { ?>
        <div class="timeline">
            <?php while (have_rows('timeline')) {
                the_row();
                $timelineCount = count(get_sub_field('timeline_images')); ?>
                <div class="timeline-entry" data-aos="fade-left" data-aos-easing="linear" data-aos-duration="1500">
                    <div class="hexagon"></div>
                    <div class="row">
                        <div class="col-xl-5">
                            <h3><?php the_sub_field('timeline_date'); ?></h3>
                            <h2><?php the_sub_field('timeline_title'); ?></h2>
                            <div class="timeline-intro">
                                <?php the_sub_field('timeline_introduction'); ?>
                            </div>
                            <div class="timeline-content">
                                <?php the_sub_field('timeline_content'); ?>
                            </div>
                            <?php if(get_sub_field('timeline_location')) { ?>
                                <div class="timeline-location">
                                    <i class="fal fa-map-marker-alt fa-2x"></i>
                                    <div class="location-content">
                                        <?php the_sub_field('timeline_location'); ?>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="offset-lg-1 col-lg-6">
                            <?php if( have_rows('timeline_images') ) {

                                switch($timelineCount){
                                    case 1:
                                        $imageClass = 'one-image';
                                        break;
                                    case 2:
                                        $imageClass = 'two-images';
                                        break;
                                    case 3:
                                        $imageClass = 'three-images';
                                        break;
                                    case 4:
                                        $imageClass = 'four-images';
                                        break;
                                    default:
                                        $imageClass = "no-images";
                                } ?>
                                <div class="timeline-images <?= $imageClass; ?>">
                                    <?php while (have_rows('timeline_images')) {
                                        the_row();
                                        $image = get_sub_field('image'); ?>
                                        <div class="hexagon-wrapper">
                                            <div class="hexagon-inner">
                                                <div class="img-hexagon" style="background-image:url('<?= $image['url']; ?>');"></div>
                                                <div class="overlay"></div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    <?php } ?>
    <div id="particles-js"></div>
</div>