<?php
namespace Blue2\Scruffy\Post;

class Product extends \Blue2\Common\BasePost
{
    public function __construct()
    {
        parent::__construct();
    }

    public static function registerPostType()
    {
        $productPostType = new \Blue2\Common\PostType("product");
        $productPostType->register("Product", "Products", [],
            [
                "menu_icon" => "dashicons-admin-site-alt3",
                "show_in_rest" => true, // Must be enabled for gutenberg support
                'rewrite' => [
                    'slug' => 'products'
                ]
            ]
        );
    }
    public static function registerTaxonomy()
    {
        $personTaxonomy = new \Blue2\Common\Taxonomy("product-category", "Product Category", "Product Categories", "product",
            [
                "show_in_rest" => true, // Must be enabled for gutenberg support
            ]
        );
    }
}