<?php

namespace Blue2\Scruffy\Controllers;

use Blue2\Scruffy\Site;
class ProductController
{
    public function __construct()
    {
        $this->registerActions();
        $this->registerFilters();
    }

    private function registerFilters(){
    }

    public function registerActions(){
        add_action( 'wp_ajax_compare_products', [$this, 'ajaxCompare'] );
        add_action( 'wp_ajax_nopriv_compare_products', [$this, 'ajaxCompare'] );
    }

    public static function generateProductArchiveItem() {

        $pageLanguage = Site::getPageLanguage();

        $title = get_field($pageLanguage . '_title') ?: get_the_title();

        //Values
        $corridorValue = get_field($pageLanguage . '_corridor') ?: get_field('corridor');
        $distanceValue = get_field('distance_%');
        $intermediateValue = get_field('intermediate_%');
        $readingValue = get_field('reading_%');
        $comfortValue = get_field('comfort_%');

        //Labels
        $corridorLabel = get_field('products_-_corridor_label', 'option') ?: 'Corridor';
        $performanceLabel = get_field('products_-_performance_label', 'option') ?: 'Performance';
        $technologyLabel = get_field('products_-_built_in_technology_label', 'option') ?: 'Built in technology';
        $compareLimitLabel = get_field('products_-_compare_limit_label', 'option') ?: 'Compare Limit Reached';
        $distanceLabel = get_field('products_-_distance_label', 'option') ?: 'Distance';
        $intermediateLabel = get_field('products_-_intermediate_label', 'option') ?: 'Intermediate';
        $readingLabel = get_field('products_-_reading_label', 'option') ?: 'Reading';
        $comfortLabel = get_field('products_-_comfort_label', 'option') ?: 'Comfort';



        $image = self::generateProductImage(get_the_id()); ?>
        <div class="product-item">
            <div class="row">
                <div class="col-lg-5 order-lg-2 image-col">
                    <div class="product-image <?= $image['image_class']; ?>">
                        <div class="hexagon-wrapper">
                            <div class="hexagon-inner">
                                <div class="img-hexagon" style="background-image:url('<?= $image['image_url']; ?>');"></div>
                                <div class="overlay"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 order-lg-1 content-col">
                    <div class="product-content">
                        <div class="product-headline">
                            <div class="row">
                                <div class="col-xl-6">
                                    <h2><?= $title; ?></h2>
                                </div>
                                <div class="col-xl-6 view-col">
                                    <div class="view-product">
                                        <?php $viewProductLabel = get_field('view_product_label', 'option') ?: 'View Product'; ?>
                                        <a href="<?php the_permalink(); ?>"><?= $viewProductLabel; ?> <i class="fal fa-arrow-right"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="archive-snippet">
                            <?php the_field('product_archive_snippet'); ?>
                        </div>
                        <div class="product-stats">
                            <div class="row">
                                <div class="col-xl-6">
                                    <?php
                                    if(have_rows('built_in_technology')) {
                                        $class = count(get_field('built_in_technology')) > 6 ? 'two-lines' : '';
                                        ?>
                                        <div class="built-in-tech">
                                            <h3><?= $technologyLabel ?></h3>
                                            <ul class="<?= $class; ?>">
                                                <?php while(have_rows('built_in_technology')) { the_row(); ?>
                                                    <li class="tech-item <?php the_sub_field('colour'); ?>" id="<?php the_sub_field('label'); ?>" title="<?php the_sub_field('label'); ?>">
                                                        <?php the_sub_field('label'); ?>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php }
                                    if($corridorValue) {?>
                                        <div class="corridor">
                                            <h3><?= $corridorLabel ?></h3>
                                            <?= $corridorValue; ?>
                                        </div>
                                    <?php } ?>
                                </div>
                                <?php
                                $performanceStats = [
                                    $distanceLabel => $distanceValue,
                                    $intermediateLabel => $intermediateValue,
                                    $readingLabel => $readingValue,
                                    $comfortLabel => $comfortValue,
                                ];
                                if(!empty($performanceStats)) { ?>
                                    <div class="col-xl-6">
                                        <div class="performance">
                                            <h3><?= $performanceLabel ?></h3>
                                            <ul>
                                                <?php foreach($performanceStats as $key => $value) { ?>
                                                    <li><div class="text"><?= $key; ?></div><div class="percentage-block"><span class="inner-percentage" style="width:<?= $value . '%'; ?>;"></span></div></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                        <?php if(get_field('activate_product_compare', 'option')) {
                            $compareSession = \Blue2\Scruffy\Controllers\ProductController::checkProductSession(get_the_id()); ?>
                            <span class="product-compare">
                                <button data-product-id="<?= get_the_id() ?>" id="<?= 'compare-item-' . get_the_id();  ?>" class="add-to-compare <?= $compareSession['button_state']; ?>"><i class="<?= $compareSession['font_awesome_class'] ?> fa-square custom-compare-svg"></i><span class="compare-text"><?= $compareSession['button_text'] ?></span></button>
                            </span>
                            <div class="limit-reached"><?= $compareLimitLabel; ?></div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    <?php }

    public static function generateProductImage($id){
        $featuredImage = get_the_post_thumbnail_url($id);
        if($featuredImage) {
            $image = $featuredImage;
            $imageClass = 'using-featured-image';
        } else {
            $image = get_field('company_logo', 'option');
            $image = $image['url'];
            $imageClass = 'using-default-image';
        }
        return ['image_class' => $imageClass, 'image_url' => $image];
    }

    public function ajaxCompare(){
        $compareProducts = $_POST['products'];
        session_start();
        $_SESSION['products'] = $compareProducts;
        self::outputCompareProducts($compareProducts);
        wp_die();
    }

    public static function checkProductSession($id) {
        if(isset($_SESSION['products'])) {
            $compareProducts = $_SESSION['products'];
            $productArray = json_decode($compareProducts);
            $fontAwesomeClass = in_array($id, $productArray) ? 'fas' : 'far';
            $compareState = in_array($id, $productArray) ? 'compare-is-active' : 'compare-inactive';
            $buttonText = in_array($id, $productArray) ? get_field('compare_remove_from_label', 'option') : get_field('compare_add_to_compare_label', 'option');

        } else {
            $buttonText = get_field('compare_add_to_compare_label', 'option');
            $compareState = "compare-inactive";
            $fontAwesomeClass = "far";
            $limit = "limit-not-reached";
        }
        return [
            'button_text' => $buttonText,
            'button_state' => $compareState,
            'font_awesome_class' => $fontAwesomeClass,
        ];
    }

    public static function outputCompareProducts($products) {

        $powerLabel = get_field('products_-_power_range_label', 'option') ?: 'Power Range';
        $corridorLabel = get_field('products_-_corridor_label', 'option') ?: 'Corridor';
        $additionLabel = get_field('products_-_additions_label', 'option') ?: 'Additions';
        $indexLabel = get_field('products_-_index_label', 'option') ?: 'Index';
        $performanceLabel = get_field('products_-_performance_label', 'option') ?: 'Performance';
        $technologyLabel = get_field('products_-_built_in_technology_label', 'option') ?: 'Built in technology';
        $distanceLabel = get_field('products_-_distance_label', 'option') ?: 'Distance';
        $intermediateLabel = get_field('products_-_intermediate_label', 'option') ?: 'Intermediate';
        $readingLabel = get_field('products_-_reading_label', 'option') ?: 'Reading';
        $comfortLabel = get_field('products_-_comfort_label', 'option') ?: 'Comfort';

        if($_SESSION['products'] !== '[]') {
            $args = [
                'post_type' => 'product',
                'post__in' => json_decode($products),
            ];
            $compareQuery = new \WP_Query($args);
            if ($compareQuery->have_posts()) {
                $productList = []; ?>
                <div class="product-bar">
                    <div class="inner-bar">
                        <?php while ($compareQuery->have_posts()) { ?>
                            <?php $compareQuery->the_post();
                            array_push($productList, get_the_title());
                        } ?>
                        <h2><span class="product-compare-title"><?php the_field('compare_products_label', 'option'); ?></span>: <?= implode(', ', $productList); ?></h2>
                        <button class="trigger-compare" aria-label="Open Compare Panel"><span class="text-section"><?php the_field('compare_label', 'option'); ?></span> <span class="d-lg-none">(<?= $compareQuery->found_posts; ?>)</span></button>
                    </div>
                </div>
                <div class="product-block">
                    <div class="row row-eq-height">
                        <?php while ($compareQuery->have_posts()) { ?>
                            <?php $compareQuery->the_post();
                            $productID = get_the_id(); ?>
                            <div class="col-lg-4 product-col">
                                <button class="remove-from-compare" data-product-id="<?php the_id() ?>" aria-label="<?= 'Remove ' . get_the_title() . ' from product compare.' ?>">
                                    <i class="fal fa-times"></i> <?php the_field('compare_short_remove_label', 'option') ?>
                                </button>
                                <div class="product-item h-100">
                                    <?php
                                    $image = get_field('comparison_image') ? wp_get_attachment_image_url(get_field('comparison_image'), 'large') : '';
                                    if($image) {
                                        ?>
                                        <img class="img-responsive compare-img" src="<?= $image; ?>" />
                                        <?php
                                    }
                                    ?>
                                    <h2><?= get_the_title($productID) ?></h2>
                                    <ul class="stat-list">
                                        <?php if(get_field('power_range')) { ?><li><span class="highlight"><?= $powerLabel; ?>: </span><?php the_field('power_range') ?></li><?php } ?>
                                        <?php if(get_field('corridor')) { ?><li><span class="highlight"><?= $corridorLabel; ?>: </span><?php the_field('corridor') ?></li><?php } ?>
                                        <?php if(get_field('index')) { ?><li><span class="highlight"><?= $indexLabel; ?>: </span><?php the_field('index') ?></li><?php } ?>
                                        <?php if(get_field('additions')) { ?><li><span class="highlight"><?= $additionLabel; ?>: </span><?php the_field('additions') ?></li><?php } ?>
                                    </ul>

                                    <?php
                                    if(have_rows('built_in_technology')) {
                                        $class = count(get_field('built_in_technology')) > 6 ? 'two-lines' : ''; ?>
                                        <div class="built-in-tech">
                                            <h3><?= $technologyLabel; ?></h3>
                                            <ul class="<?= $class; ?>">
                                                <?php while(have_rows('built_in_technology')) { the_row(); ?>
                                                    <li class="tech-item <?php the_sub_field('colour'); ?>" id="<?php the_sub_field('label'); ?>" title="<?php the_sub_field('label'); ?>">
                                                        <?php the_sub_field('label'); ?>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php }
                                    $performanceStats = [
                                        $distanceLabel => get_field('distance_%'),
                                        $intermediateLabel => get_field('intermediate_%'),
                                        $readingLabel => get_field('reading_%'),
                                        $comfortLabel => get_field('comfort_%'),
                                    ];
                                    if(!empty($performanceStats)) { ?>
                                        <div class="performance">
                                            <h3><?= $performanceLabel; ?></h3>
                                            <ul>
                                                <?php foreach($performanceStats as $key => $value) { ?>
                                                    <li><div class="text"><?= $key; ?></div><div class="percentage-block"><span class="inner-percentage" style="width:<?= $value . '%'; ?>;"></span></div></li>
                                                <?php } ?>
                                            </ul>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php }  ?>
                    </div>
                </div>
            <?php } ?>
        <?php }
    }
}
