<?php
$pageLanguage = Blue2\Scruffy\Site::getPageLanguage();
switch($pageLanguage){
    case 'english':
        $pageLanguageSlug = false;
        break;
    case 'spanish':
        $pageLanguageSlug = 'es';
        break;
    case 'portuguese':
        $pageLanguageSlug = 'pt-br';
        break;
    case 'chinese':
        $pageLanguageSlug = 'zh';
        break;
}
global $post;
$title = get_field($pageLanguage . '_title') ?: get_the_title();
$caption = get_field($pageLanguage . '_short_caption') ?: get_field('short_caption');
$viewPostsLabel = get_field('view_posts_label', 'option') ?: 'View Post';
$image = get_the_post_thumbnail_url();
$darkMode = get_field('enable_dark_mode', 'option');
?>

<div class="section section--featured-post <?php if($darkMode) { echo 'dark'; } ?>">
    <div class="panel-wrapper">
        <div class="panel panel--left">
            <img src="<?= $image; ?>" class="img-responsive"/>
            <div class="date"><?= get_the_date('d/m/Y'); ?></div>
        </div>
        <div class="panel panel--right">
            <h2><?= $title; ?></h2>
            <div class="caption"><strong><?= $caption; ?></strong></div>
            <div class="content"><?php the_excerpt();  ?></div>
            <a href="<?php the_permalink(); ?>" class="cta"><?= $viewPostsLabel; ?> <i class="fal fa-long-arrow-right"></i></a>
        </div>
    </div>
</div>
<?php wp_reset_postdata();
