<?php
$pageLanguage = Blue2\Scruffy\Site::getPageLanguage();

$title = get_field($pageLanguage . '_title') ?: get_the_title();

//Values
$powerRangeValue = get_field($pageLanguage . '_power_range') ?: get_field('power_range');
$corridorValue = get_field($pageLanguage . '_corridor') ?: get_field('corridor');
$additionsValue = get_field($pageLanguage . '_additions') ?: get_field('additions');
$distanceValue = get_field('distance_%');
$intermediateValue = get_field('intermediate_%');
$readingValue = get_field('reading_%');
$comfortValue = get_field('comfort_%');
$indexValue = get_field($pageLanguage . '_index') ?: get_field('index');
$technologyValue = get_field($pageLanguage . '_built_in_technology') ?: get_field('built_in_technology');
$darkMode = get_field('enable_dark_mode');

//Labels
$powerLabel = get_field('products_-_power_range_label', 'option') ?: 'Power Range';
$corridorLabel = get_field('products_-_corridor_label', 'option') ?: 'Corridor';
$additionLabel = get_field('products_-_additions_label', 'option') ?: 'Additions';
$indexLabel = get_field('products_-_index_label', 'option') ?: 'Index';
$performanceLabel = get_field('products_-_performance_label', 'option') ?: 'Performance';
$technologyLabel = get_field('products_-_built_in_technology_label', 'option') ?: 'Built in technology';
$enquireLabel = get_field('products_-_enquire_label', 'option') ?: 'Enquire';
$compareLimitLabel = get_field('products_-_compare_limit_label', 'option') ?: 'Compare Limit Reached';
$downloadBrochureLabel = get_field('products_-_download_brochure_label', 'option') ?: 'Download Brochure';
$distanceLabel = get_field('products_-_distance_label', 'option') ?: 'Distance';
$intermediateLabel = get_field('products_-_intermediate_label', 'option') ?: 'Intermediate';
$readingLabel = get_field('products_-_reading_label', 'option') ?: 'Reading';
$comfortLabel = get_field('products_-_comfort_label', 'option') ?: 'Comfort';
?>

<div class="section section--product-single product-single-item <?php if($darkMode) { echo 'dark'; } ?>">
    <div class="custom-product-single">
        <?php
        if ( function_exists('yoast_breadcrumb') ) {
            yoast_breadcrumb( '<p id="breadcrumbs">','</p>' );
        }
        ?>
        <div class="product-content">
            <div class="product-stats">
                <div class="row">
                    <div class="col-lg-6 col-xl-4 order-xl-1">
                        <?php
                        if($powerRangeValue) { ?>
                            <div class="power-range">
                                <h3><?= $powerLabel; ?></h3>
                                <?= $powerRangeValue; ?>
                            </div>
                        <?php }
                        if($corridorValue) {?>
                            <div class="corridor">
                                <h3><?= $corridorLabel; ?></h3>
                                <?= $corridorValue; ?>
                            </div>
                        <?php }
                        if($additionsValue) {?>
                            <div class="additions">
                                <h3><?= $additionLabel; ?></h3>
                                <?= $additionsValue; ?>
                            </div>
                        <?php }
                        if($indexValue) {?>
                            <div class="index">
                                <h3><?= $indexLabel; ?></h3>
                                <?= $indexValue; ?>
                            </div>
                        <?php }  ?>
                    </div>

                    <?php
                    $performanceStats = [
                        $distanceLabel => $distanceValue,
                        $intermediateLabel => $intermediateValue,
                        $readingLabel => $readingValue,
                        $comfortLabel => $comfortValue,
                    ];
                    if(!empty($performanceStats)) { ?>
                        <div class="col-xl-4 col-lg-6 order-xl-2">
                            <div class="performance">
                                <h3><?= $performanceLabel; ?></h3>
                                <ul>
                                    <?php foreach($performanceStats as $key => $value) { ?>
                                        <li><div class="text"><?= $key; ?></div><div class="percentage-block"><span class="inner-percentage" style="width:<?= $value . '%'; ?>;"></span></div></li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if($technologyValue) {
                        $class = count($technologyValue) > 6 ? 'two-lines' : ''; ?>
                        <div class="col-xl-4 order-xl-3">
                            <div class="built-in-tech">
                                <h3><?= $technologyLabel; ?></h3>
                                <ul class="<?= $class; ?>">
                                    <?php foreach($technologyValue as $tech) {  ?>
                                        <li class="tech-item <?= $tech['colour']; ?>" id="<?= $tech['label']; ?>" title="<?= $tech['label']; ?>">
                                            <?= $tech['label']; ?>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="product-main">
                <div class="row">
                    <div class="col-lg-6">
                        <?php $galleryImages = get_field('product_gallery'); ?>
                        <?php if($galleryImages) { ?>
                            <div class="product-gallery">
                                <div class="custom-swiper-container gallery-top">
                                    <div class="swiper-wrapper">
                                        <?php foreach($galleryImages as $image) { ?>
                                            <div class="swiper-slide" style="background-image:url('<?= $image['url']; ?>')"></div>
                                        <?php } ?>
                                    </div>
                                    <div class="swiper-button-next swiper-button-white"></div>
                                    <div class="swiper-button-prev swiper-button-white"></div>
                                </div>
                                <div class="custom-swiper-container gallery-thumbs">
                                    <div class="swiper-wrapper">
                                        <?php foreach($galleryImages as $image) { ?>
                                            <div class="swiper-slide" style="background-image:url('<?= $image['url']; ?>')"></div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-lg-6">
                        <div class="main-content">
                            <h2><?= $title; ?></h2>
                            <?php the_content(); ?>

                            <?php
                            if (defined( 'ICL_LANGUAGE_CODE' )) {
                                $language = ICL_LANGUAGE_CODE;
                                if($language !== 'en') {
                                    $urlPrepend = "/" . $language;
                                } else{
                                    $urlPrepend = "";
                                }
                            } else {
                                $urlPrepend = "";
                            }
                            ?>

                            <div class="ctas">
                                <ul>
                                    <li><a href="<?= $urlPrepend . '/enquire/?enquiry-topic=' . get_the_title(); ?>"><?= $enquireLabel; ?></a></li>
                                    <?php $brochure = get_field('download_brochure');
                                    if($brochure) { ?>
                                        <li><a href="<?= $brochure['url']; ?>"><?= $downloadBrochureLabel ?></a></li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php if(get_field('activate_product_compare', 'option')) {
                                $compareSession = \Blue2\Scruffy\Controllers\ProductController::checkProductSession(get_the_id()); ?>
                                <span class="product-compare">
                                    <button data-product-id="<?= get_the_id() ?>" id="<?= 'compare-item-' . get_the_id();  ?>" class="add-to-compare <?= $compareSession['button_state']; ?>"><i class="<?= $compareSession['font_awesome_class'] ?> fa-square custom-compare-svg"></i><span class="compare-text"><?= $compareSession['button_text'] ?></span></button>
                                </span>
                                <div class="limit-reached"><?= $compareLimitLabel; ?></div>
                            <?php } ?>
                            <div class="addthis_inline_share_toolbox"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

