<?php 
$image = get_the_post_thumbnail_url(get_the_ID(), 'large');
$darkMode = get_field('enable_dark_mode');
?>
<div class="person-wrapper <?php if($darkMode) { echo 'dark'; } ?>" id="person-<?= get_the_ID(); ?>" data-email="<?php the_field('email'); ?>" data-phone-number="<?php the_field('phone_number'); ?>" data-name="<?php the_title(); ?>" data-title="<?php the_field('job_title'); ?>" data-img="<?= $image; ?>">
    <div class="hexagon-wrapper">
        <div class="hexagon-inner">
            <div class="img-hexagon" style="background-image:url('<?= $image; ?>');"></div>
            <div class="overlay"></div>
        </div>
    </div>
    <div class="content">
        <h3><?php the_title(); ?></h3>
        <p><?php the_field('job_title'); ?></p>
    </div>
    <div class="d-none description">
        <?php the_content(); ?>
    </div>
</div>
