<?php
$language = Blue2\Scruffy\Site::getPageLanguage();
$languageMenu = $language . "_menu";
$languageTopMenu = "top_" . $language . "_menu";
$regionLabel = get_field('new_in_region_label', 'option') ?: 'Whats in your region?';
$regionUrl = get_field('new_in_region_url', 'option') ?: '/blog/';


if(is_home() || is_singular('post')) {
    $bannerWidth = get_field('blog_archive_banner_banner_width', 'option');
    $bannerImg = get_field('blog_archive_banner_thin_banner_image', 'option');
    $bannerVideo = get_field('blog_archive_banner_video');
    $overlay = get_field('blog_archive_banner_overlay_colour', 'option');
    $liveChatOn = get_field('blog_archive_banner_live_chat_on', 'option');
    $regionUpdateOn = get_field('blog_archive_banner_region_update_on', 'option');
} elseif(is_post_type_archive('person') || is_singular('person')) {
    $bannerWidth = 'thin';
    $bannerImg = get_field('person_archive_thin_banner_image', 'option');
    $overlay = get_field('person_archive_overlay_colour', 'option');
    $liveChatOn = get_field('person_archive_live_chat_on', 'option');
    $regionUpdateOn = false;
} elseif(is_post_type_archive('product') || is_tax('product-category')) {
    $bannerWidth = is_tax('product-category') ? 'thin' : get_field('product_archive_banner_width', 'option');
    $bannerImg = get_field('product_archive_thin_banner_image', 'option');
    $bannerVideo = get_field('product_archive_banner_video');
    $overlay = get_field('product_archive_overlay_colour', 'option');
    $liveChatOn = get_field('product_archive_live_chat_on', 'option');
    $regionUpdateOn = false;
} elseif(is_404() || is_search()) {
    $bannerWidth = get_field('404_banner_width', 'option');
    $bannerImg = get_field('404_thin_banner_image', 'option');
    $bannerVideo = get_field('404_banner_video');
    $overlay = get_field('404_overlay_colour', 'option');
    $liveChatOn = get_field('404_live_chat_on', 'option');
    $regionUpdateOn = get_field('404_region_update_on', 'option');
} else {
    $bannerWidth = get_field('banner_width');
    $bannerImg = get_field('thin_banner_image');
    $bannerVideo = get_field('banner_video');
    $mobileBannerVideo = get_field('mobile_banner_video');
    $overlay = get_field('overlay_colour');
    $liveChatOn = get_field('live_chat_on');
    $regionUpdateOn = get_field('region_update_on');
}

if($bannerWidth == 'video') {
    $extraClass = 'video-background';
} else {
    $extraClass = '';
}

if($bannerImg || $bannerVideo) {
    $bannerImg = wp_get_attachment_image_src($bannerImg, 'full'); ?>
    <section class="section section--header section--header-<?= $overlay; ?> <?= $extraClass; ?>">
        <?php if($bannerWidth == 'video') { ?>
            <div class="background-video">

                <?= \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-2.svg', 'hex-2', '', false) ?>

                <video class="desktop-video <?= $mobileBannerVideo ? 'mobile-video-added' : 'no-mobile-video'; ?>" no-controls autoplay muted loop>
                    <source src="<?= $bannerVideo; ?>" type="video/mp4" />
                </video>

                <?php if($mobileBannerVideo) { ?>
                    <video class="mobile-video" no-controls autoplay muted loop>
                        <source src="<?= $mobileBannerVideo; ?>" type="video/mp4" />
                    </video>
                <?php } ?>

                <div class="video-text">
                    Providing A Clear Vision For the Future
                </div>
                <div class="explore-text">
                    <?= \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-3.svg', 'explore-hex', '', false) ?>
                    <div class="text">Explore</div>
                    <div class="icon">&#9660;</div>
                </div>
            </div>
        <?php } else { ?>
            <div class="background-image" style="background-image: url('<?= $bannerImg[0]; ?>');"></div>
        <?php } ?>

        <div class="overlay overlay--<?= $overlay; ?>"></div>
        <div class="header-wrapper">
            <nav class="header-nav">
                <?php
                $logoWhite = get_field('white_logo', 'option') ? wp_get_attachment_image_src(get_field('white_logo', 'option'), 'full') : '';
                $logoDark = get_field('dark_logo', 'option') ? wp_get_attachment_image_src(get_field('dark_logo', 'option'), 'full') : '';
                ?>
                <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
                    <img class="white" src="<?= $logoWhite[0]; ?>" alt="<?php bloginfo('name'); ?>" />
                    <img class="dark" src="<?= $logoDark[0]; ?>" alt="<?php bloginfo('name'); ?>" />
                </a>

                <?php include(locate_template('templates/parts/part-languages.php')); ?>

                <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <input class="burger-check" id="burger-check" type="checkbox">
                    <label for="burger-check" class="burger"><span class="sr-only">Toggle menu</span></label>
                </button>

                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <?php
                    if (has_nav_menu($languageTopMenu)) {
                        wp_nav_menu(['theme_location' => $languageTopMenu, 'menu_class' => 'navigation']);
                    } else {
                        wp_nav_menu(['theme_location' => 'top_english_menu', 'menu_class' => 'navigation']);
                    }
                    ?>
                    <div class="mobile-menu">
                        <?php
                        if (has_nav_menu($languageMenu)) {
                            wp_nav_menu(['theme_location' => $languageMenu, 'menu_class' => 'navigation']);
                        } else {
                            wp_nav_menu(['theme_location' => 'english_menu', 'menu_class' => 'navigation']);
                        }
                        ?>
                    </div>
                </div>

                <?php if(have_rows('social_media_channels', 'options')) { ?>
                    <div class="social-media">
                        <?php if(get_field('contact_email_address', 'option')) { ?>
                            <a href="mailto:<?php the_field('contact_email_address', 'option'); ?>" class="social-media--icon">
                                <i class="fal fa-envelope"></i>
                            </a>
                        <?php }
                        while(have_rows('social_media_channels', 'options')) { the_row(); ?>
                            <a href="<?php the_sub_field('full_url'); ?>" class="social-media--icon">
                                <i class="<?php the_sub_field('fa5_icon_class'); ?>"></i>
                            </a>
                        <?php } ?>
                    </div>
                <?php } ?>

                <div class="search-wrapper">
                    <form role="search" method="get" id="searchform" class="search-content searchform" action="<?= esc_url( home_url( '/' ) ); ?>">
                        <div class="search--form">
                            <input type="text" value="<?= get_search_query(); ?>" name="s" id="s" class="banner-text-box" placeholder="<?php the_field('search_label', 'option') ?>" />
                            <button id="searchsubmit" class="banner-text-btn" ><i class="fal fa-search"></i></button>
                        </div>
                    </form>
                </div>
            </nav>

            <div class="bottom-menu">
                <div class="bottom-menu--inner">
                    <div class="<?= $language; ?>-menu banner-menu">
                        <?php
                        if (has_nav_menu($languageMenu)) {
                            wp_nav_menu(['theme_location' => $languageMenu, 'menu_class' => 'navigation']);
                        } else {
                            wp_nav_menu(['theme_location' => 'english_menu' , 'menu_class' => 'navigation']);
                        }
                        ?>
                    </div>

                    <div class="search-wrapper">
                        <form role="search" method="get" id="searchform" class="search-content searchform" action="<?= esc_url( home_url( '/' ) ); ?>">
                            <div class="search--form">
                                <input type="text" value="<?= get_search_query(); ?>" name="s" id="s" class="banner-text-box" placeholder="<?php the_field('search_label', 'option') ?>" />
                                <button id="searchsubmit" class="banner-text-btn" ><i class="fal fa-search"></i></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php
        if($bannerWidth == 'full') {
            if(is_home()) {
                $count = count(get_field('blog_archive_banner_slider', 'option'));
            } elseif(is_singular('post')) {
                $count = false;
            } else {
                $count = count(get_field('slider'));
            }
            if($count) {
                $swiperClass = $count > 1 ? 'swiper-container' : 'single-swiper-container';
                ?>
                <div class="banner-wrapper">
                    <div class="<?= $swiperClass; ?>">
                        <div class="swiper-wrapper">
                            <?php
                            if(is_home()) {
                                while(have_rows('blog_archive_banner_slider', 'option')) {
                                    the_row();
                                    include(locate_template('templates/parts/banner-content.php'));
                                }
                            } else {
                                while(have_rows('slider')) {
                                    the_row();
                                    include(locate_template('templates/parts/banner-content.php'));
                                }
                            }
                            ?>
                        </div>

                        <?php if( $count > 1) { ?>
                            <div class="swiper-pagination"></div>
                        <?php } ?>
                    </div>

                    <?php if($regionUrl && $regionUpdateOn) { ?>
                        <div class="region-wrapper">
                            <a href="<?= $regionUrl; ?>" class="region-link">
                                <div class="region-banner-overlay">
                                    <h4><?= $regionLabel; ?></h4>
                                    <img class="img-responsive" src="<?= get_template_directory_uri(); ?>/dist/images/map.svg" alt="map"/>
                                </div>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            <?php }
        } ?>
    </section>
    <?php
}
