<?php
$pageLanguage = Blue2\Scruffy\Site::getPageLanguage();
switch($pageLanguage){
    case 'english':
        $pageLanguageSlug = false;
        break;
    case 'spanish':
        $pageLanguageSlug = 'es';
        break;
    case 'portuguese':
        $pageLanguageSlug = 'pt-br';
        break;
    case 'chinese':
        $pageLanguageSlug = 'zh-hans';
        break;
}
$title = get_field($pageLanguage . '_title') ?: get_the_title();
$caption = get_field($pageLanguage . '_short_caption') ?: get_field('short_caption');
$recentBlogsLabel = get_field('recent_blogs_label', 'option') ?: 'Recent Blogs';
$viewPostsLabel = get_field('view_posts_label', 'option') ?: 'View Post';
$darkMode = get_field('enable_dark_mode');
?>

<div class="section section--post-single <?php if($darkMode) { echo 'dark'; } ?>">
    <div class="post-single--inner">
        <div class="main-content">
            <span class="date"><?= get_the_date('d/m/Y'); ?></span>
            <h1><?= $title; ?></h1>
            <?php $image = get_the_post_thumbnail_url(get_the_ID(), 'full'); 
                $alt =  get_the_title(get_post_thumbnail_id());
            ?>
            <img src="<?= $image; ?>" class="img-responsive image-inner" alt="<?=$alt;?>"/>
            <div class="short-caption"><?= $caption; ?></div>
            <?php the_content(); ?>
        </div>

        <div class="sidebar">
            <h2><?= $recentBlogsLabel; ?></h2>
            <?php
            $recentBlogs = get_posts(['numberposts' => 5, 'exclude' => [get_the_ID()]]);
            foreach($recentBlogs as $post) {
                setup_postdata($post);
                $title = get_field($pageLanguage . '_title') ?: get_the_title();
                $caption = get_field($pageLanguage . '_short_caption') ?: get_field('short_caption');
                $link = $pageLanguage !== 'english' ? '/' . $pageLanguageSlug . '/' . $post->post_name : get_the_permalink(); ?>
                <div class="recent-blog-wrapper">
                    <a href="<?= $link; ?>">
                        <h3><?= $title; ?></h3>
                        <span class="date"><?= get_the_date('d/m/Y'); ?></span>
                        <div class="short-caption"><?= $caption; ?></div>
                    </a>
                </div>
                <?php
            }
            wp_reset_postdata();
            ?>

        </div>
    </div>
</div>
