<?php
$pageLanguage = Blue2\Scruffy\Site::getPageLanguage();
switch($pageLanguage){
    case 'english':
        $pageLanguageSlug = false;
        $defaultContent = true;
        break;
    case 'spanish':
        $pageLanguageSlug = 'es';
        $defaultContent = false;
        break;
    case 'portuguese':
        $pageLanguageSlug = 'pt-br';
        $defaultContent = false;
        break;
    case 'chinese':
        $pageLanguageSlug = 'zh';
        $defaultContent = false;
        break;
}
global $post;
$title = get_field($pageLanguage . '_title') ?: get_the_title();
$caption = get_field($pageLanguage . '_short_caption') ?: get_field('short_caption');
$link = $pageLanguage !== 'english' ? '/' . $pageLanguageSlug . '/' . $post->post_name : get_the_permalink();
$image = get_the_post_thumbnail_url(get_the_ID(), 'large');
$darkMode = get_field('enable_dark_mode');
?>

<div class="post-wrapper <?php if($darkMode) { echo 'dark'; } ?>">
    <a href="<?= $link; ?>" class="post-wrapper--url">
        <div class="image" style="background-image:url('<?= $image; ?>');">
            <div class="date"><?= get_the_date('d/m/Y'); ?></div>
        </div>
        <div class="content">
            <h3><?= $title; ?></h3>
            <p><?= $caption; ?></p>
            <span class="cta"><i class="fal fa-arrow-right"></i></span>
        </div>
    </a>
</div>
