<?php
$firstClass = get_sub_field('proportion') == '70-30' ? 'order-1' : 'order-2';
$additionalPadding = get_sub_field('padding_for_overlay') ? 'additional-padding' : '';
$backgroundImage = get_sub_field('background_full_width');
$disableSVGs = get_sub_field('disable_svgs');

if(have_rows('70_column')) {
    while(have_rows('70_column')) {
        the_row();
        $image = get_sub_field('background_type') === 'image' && get_sub_field('background_image') ?
            wp_get_attachment_image_src(get_sub_field('background_image'), 'full') : '';
        ?>
        <div class="panel-wrapper panel-wrapper--70 <?= $firstClass; ?>
            <?php if(get_sub_field('background_type') === 'colour') { the_sub_field('background_colour'); } ?>
            <?php if($image) { ?> image-bg <?php } ?>"
            <?php if($image && !$backgroundImage) { ?>style="background-image:url('<?= $image[0]; ?>');"<?php } ?>>
            <div class="panel <?= $additionalPadding; ?>">


                <?php
                if(!$backgroundImage && !have_rows('boxes') && !$disableSVGs) {
                    \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-1.svg', 'hex-3-main', '', false);
                }
                ?>


                <?php if(have_rows('content_wrapper') || have_rows('boxes')) {
                    while(have_rows('content_wrapper')) {
                        the_row();
                        if(get_sub_field('subtitle') || get_sub_field('title') || get_sub_field('content')) {?>
                            <div class="panel--inner">
                                <?php if(get_sub_field('subtitle')) { ?>
                                    <h3><?php the_sub_field('subtitle'); ?></h3>
                                <?php } ?>

                                <?php if(get_sub_field('title')) { ?>
                                    <h2><?php the_sub_field('title'); ?></h2>
                                <?php } ?>



                                <div class="content">
                                    <?php the_sub_field('content'); ?>
                                </div>
                            </div>
                            <?php
                            include(locate_template('templates/parts/part-cta.php'));
                        }
                    }
                    ?>

                <?php } ?>
                <?php if(have_rows('boxes')) { ?>

                    <?php
                    if(!$backgroundImage && !$disableSVGs) {
                        \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-1.svg', 'hex-3-boxes', '', false);
                        \Blue2\Scruffy\Site::inlineSVG('/dist/images/hexagons/hex-1.svg', 'hex-3-boxes-2', '', false);
                    }
                    ?>

                    <div class="boxes-wrapper">
                        <?php while(have_rows('boxes')) { the_row(); ?>
                            <div class="box">
                                <h2><?php the_sub_field('title'); ?></h2>
                                <div class="content"><?php the_sub_field('content'); ?></div>

                                <?php include(locate_template('templates/parts/part-cta.php')); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
            </div>

        </div>
    <?php
    }
}
