<?php session_start(); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
    /**
     * Fonts loaded from Typekit but deferred with high priority
     *
     * @see https://csswizardry.com/2020/05/the-fastest-google-fonts/
     */
    $font_url = 'https://use.typekit.net/akv5uef.css';
    ?>
    <link rel="preconnect" href="https://use.typekit.net" crossorigin>
    <link rel="preconnect" href="https://p.typekit.net" crossorigin>
    <link rel="preload" as="style" href="<?= $font_url; ?>">
    <link rel="stylesheet" href="<?= $font_url; ?>" media="print" onload="this.media='all'" />
    <noscript><link rel="stylesheet" href="<?= $font_url ?>" /></noscript>
    <!-- Start of Zendesk Widget script -->
    <script id="ze-snippet" src="https://static.zdassets.com/ekr/snippet.js?key=web_widget/crossbowsoptical.zendesk.com"></script>
    <!-- End of Zendesk Widget script -->
    <?php wp_head(); ?>
</head>

<?php $language = defined('ICL_LANGUAGE_CODE') ? ICL_LANGUAGE_CODE : 'en'; ?>

<body <?php body_class(); ?> data-language-code="<?= $language; ?>">
