<?php
$language = Blue2\Scruffy\Site::getPageLanguage();
$footerMenu = "footer_" . $language . "_menu";
$bottomFooterMenu = "footer_" . $language . "_terms_menu";

$quickLinks = get_field('quick_links_label', 'option') ?: 'Quick Links';
$contactUs = get_field('contact_us_label', 'option') ?: 'Contact Us';
$selectLanguage = get_field('select_a_language_label', 'option') ?: 'Select a Language';
$regionLabel = get_field('new_in_region_label', 'option') ?: 'Whats new in your region?';
$regionUrl = get_field('new_in_region_url', 'option') ?: '/blog/';

?>
<footer class="site-footer">
    <div class="site-footer--top">
        <div class="site-footer--top-left">
            <nav class="navigation">
                <h3><?= $quickLinks; ?></h3>
                <?php
                if (has_nav_menu($footerMenu)) {
                    wp_nav_menu(['theme_location' => $footerMenu, 'menu_class' => '']);
                } else {
                    wp_nav_menu(['theme_location' => 'footer_english_menu', 'menu_class' => '']);
                }
                ?>
            </nav>

            <div class="contact-us">
                <h3><?= $contactUs; ?></h3>
                <div class="address">
                    <?php the_field('footer_address', 'options'); ?>
                </div>
                <a class="tel" href="tel:<?php the_field('tel_url', 'options'); ?>"><?php the_field('tel_label', 'options'); ?></a>
                <a class="email" href="mailto:<?php the_field('email_address', 'options'); ?>"><?php the_field('email_address', 'options'); ?></a>
            </div>
        </div>

        <div class="site-footer--top-right">
            <img class="footer-hex" src="<?= get_template_directory_uri() . '/dist/images/footer-image.png'; ?>" />
            <h3><?= $regionLabel; ?></h3>
            <div class="button-container">
                <?php if($regionUrl) { ?>
                    <a href="<?= $regionUrl; ?>" class="btn btn-default blog-button">View Our Innovation Blog</a>
                <?php } ?>
            </div>
        </div>
    </div>

    <div class="site-footer--bottom">
        <div class="site-footer--bottom-main">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-lg-4 col-md-12 d-flex p-0">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-lg-5 col-md-6 p-0">
                                    <div class="copyright">
                                        <p>&copy; <?= date("Y"); ?> <?php bloginfo('name'); ?></p>
                                    </div>
                                </div>

                                <div class="col-lg-7 col-md-6 p-0">
                                    <div class="navigation-terms">
                                        <?php
                                        if (has_nav_menu($bottomFooterMenu)) {
                                            wp_nav_menu(['theme_location' => $bottomFooterMenu, 'menu_class' => 'navigation-terms--menu']);
                                        } else {
                                            wp_nav_menu(['theme_location' => 'footer_english_terms_menu', 'menu_class' => 'navigation-terms--menu']);
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6 d-flex language-container p-0">
                        <?php if($selectLanguage) { ?>
                            <div class="language-selector">
                                <p><?= $selectLanguage; ?></p>
                                <?php include(locate_template('templates/parts/part-languages.php')); ?>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="col-lg-4 col-md-6 d-flex p-0 credit-container">
                    <div class="credit">
                        <a target="_blank" href="https://blue2.co.uk/"><img class="footer-blue2" src="<?= get_template_directory_uri() . '/dist/images/blue2-footer.png'; ?>" /></a>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php if(get_field('activate_product_compare', 'option')) { ?>
    <div class="product-compare-area" data-compare-products="<?php if(isset($_SESSION['products'])) { echo $_SESSION['products'];  } ?>">
        <div class="compare-content">
            <?php if(isset($_SESSION['products']) && ($_SESSION['products'] !== '[]')) {
                $compareProducts = $_SESSION['products'];
                \Blue2\Scruffy\Controllers\ProductController::outputCompareProducts($compareProducts);
            } ?>
        </div>
    </div>
<?php } ?>
