const person = () => {
    $('.person-wrapper').each((_index, val) => {
        $(val).click(() => {
            const name = $(val).data('name');
            const title = $(val).data('title');
            const imgUrl = $(val).data('img');
            const phone = $(val).data('phone-number');
            const email = $(val).data('email');
            let img = 'url("';
            img = img.concat(imgUrl, '")');
            console.log(img);
            const description = $(val).find('.description')
                .first()
                .html();

            $('.person-details .name').html(name);
            $('.person-details .title').html(title);
            if (phone !== '') {
                $('.person-details .phone').html(`<span class="detail-highlight">Phone</span>: <a href="tel:${phone}">${phone}</a>`);
            } else {
                $('.person-details .phone').hide();
            }
            $('.person-details .email').html(`<span class="detail-highlight">Email</span>: <a href="mailto:${email}">${email}</a>`);
            $('.person-details .img-hexagon').css('background-image', img);
            $('.person-details .content').html(description);
            $('.person-details').fadeIn('fast');

            $(window).resize(() => {
                if ($(window).width() >= 1504) {
                    $('.person-details .title').css('border-left', '2px solid #01437D');
                }
            });

            $('html, body').animate({
                scrollTop: $('.person-details').offset().top
            }, 300);
        });
    });
};

export default person;
