const compare = () => {
    function postCompareInfo(compareProducts) {
        $.ajax({
            type: 'POST',
            url: ajaxObject.ajax_url,
            data: {
                action: 'compare_products',
                products: compareProducts,
            },
            success(data) {
                $('.compare-content').html(data);
            }
        });
    }

    function removeCompareInfo(compareProducts) {
        $.ajax({
            type: 'POST',
            url: ajaxObject.ajax_url,
            data: {
                action: 'compare_products',
                products : compareProducts,
            },
            success(data) {
                $('.compare-content').html(data);
                $('.trigger-compare').find('.text-section')
                    .text('Close');
                if (!data) {
                    $('.product-compare-area').removeClass('active-compare');
                    $('.site-footer').removeClass('active-compare-footer');
                }
            }
        });
    }

    function checkProductCount(products) {
        if (products.length === 3) {
            $('.limit-reached').show();
            $('.compare-inactive').hide();
            $('.compare-inactive.compare-is-active').show();
        } else {
            $('.limit-reached').hide();
            $('.compare-inactive').show();
        }
    }

    $(document).ready(() => {
        /* global ajaxObject */
        const productData = $('.product-compare-area').attr('data-compare-products');
        const products = productData ? $.parseJSON(productData) : [];
        const languageWPML = $('body').data('language-code');

        let addText = '';
        let removeText = '';

        if (languageWPML === 'zh-hans') {
            addText = '加入比较';
            removeText = '删除';
        } else if (languageWPML === 'es') {
            addText = 'Añadir a Comparar';
            removeText = 'RETIRAR DE COMPARAR';
        } else if (languageWPML === 'pt-br') {
            addText = 'Adicionar para comparar';
            removeText = 'RETIRAR DA COMPARAÇÃO';
        } else {
            addText = 'Add to compare';
            removeText = 'Remove from compare';
        }

        checkProductCount(products);
        $('body').on('click', '.add-to-compare', function(e) {
            e.preventDefault();
            const productId = $(this).data('product-id');
            $(`#compare-item-${productId}`).toggleClass('compare-is-active');
            $('.site-footer').toggleClass('active-compare-footer');
            const compareSelector = $(`#compare-item-${productId}, .mobile-overlay-block #compare-item-${productId}`);
            if ($(this).hasClass('compare-is-active')) {
                compareSelector.find('.compare-text')
                    .text(removeText);
                compareSelector.find('.custom-compare-svg')
                    .attr('data-prefix', 'fas');
                products.push(productId); // add product id to array
                checkProductCount(products);
            } else {
                compareSelector.find('.compare-text')
                    .text(addText);
                compareSelector.find('.custom-compare-svg')
                    .attr('data-prefix', 'far');
                products.splice($.inArray(productId, products), 1); // remove product id from array
                checkProductCount(products);
            }
            const compareProducts = JSON.stringify(products);
            postCompareInfo(compareProducts);
        });

        $('body').on('click', '.remove-from-compare', function(e) {
            e.preventDefault();
            const productId = $(this).data('product-id');
            products.splice($.inArray(productId, products), 1);
            const compareProducts = JSON.stringify(products);
            $(`#compare-item-${productId}`).toggleClass('compare-is-active');
            $(`#compare-item-${productId}`).find('.custom-compare-svg')
                .attr('data-prefix', 'far');
            $(`#compare-item-${productId}`).find('.compare-text')
                .text(addText);
            removeCompareInfo(compareProducts);
            checkProductCount(products);
            checkProductCount(compareProducts);
        });
    });

    $('body').on('click', '.trigger-compare', function() {
        const languageWPML = $('body').data('language-code');
        let compareText = '';
        let closeText = '';
        if (languageWPML === 'zh-hans') {
            compareText = '比较';
            closeText = '关';
        } else if (languageWPML === 'es') {
            compareText = 'Cerca';
        } else if (languageWPML === 'pt-br') {
            compareText = 'Fechar';
        } else {
            compareText = 'Compare';
            closeText = 'Close';
        }

        $('.product-compare-area').toggleClass('active-compare');
        if ($('.product-compare-area').hasClass('active-compare') === true) {
            $(this).find('.text-section')
                .text(closeText);
            $('.product-block').focus();
        } else {
            $(this).find('.text-section')
                .text(compareText);
        }
    });
};

export default compare;
