<?php
$term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
$people = new WP_Query(array(
    "post_type" => "person",
    "posts_per_page" => -1,
    "tax_query" => array(
        array(
            "taxonomy" => "department",
            'field' => 'slug',
            "terms" => $term->slug
        )
    ),
    "meta_key" => 'person_order',
    "orderby" => "meta_value",
    "order" => "ASC"
        ));

$rightImage = wp_get_attachment_image_src(get_field('banner_image', $term)) ? wp_get_attachment_image_src(get_field('banner_image', $term), "full", array(
            'class' => 'img-responsive')) : array(
    "https://dummyimage.com/1200x1200/cccccc/000000.jpg&text=Pending+");
?>
<div class="row">
    <div class="col-xs-12 col-sm-7 col-sm-push-5 galleryGrid">
        <div id="contentBox" class="ggWrap section1">
            <div class="row">
                <div class="col-xs-12 imageBlock fade-in one" style="background-image: url(<?php echo $rightImage[0]; ?>); height: 100%"></div>
            </div>
        </div>
    </div>

    <!-- Content Pan -->
    <div class="col-xs-12 col-sm-5 contentGrid weddingSection">
        <div class="cgWrap" id="contentHome">

            <h1 class="introMessage text-center"><?php echo $term->name; ?></h1>
            <p class="breadcrumbs">
                <?php
                if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs">', '</p>');
                }
                ?>
            </p>

            <?php if ($people->have_posts()) { ?>
                <div class="row">
                    <?php
                    while ($people->have_posts()) {
                        $people->the_post();
                        $dummy = \Roots\Sage\Assets\asset_path('images/staffdefault.png');
                        $mainImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "people-preview-image", false) ? wp_get_attachment_image_src(get_post_thumbnail_id(), 'people-preview-image', false) : array(
                            $dummy);
//                            var_dump($mainImage);
                        ?>
                        <div class="col-xs-12 col-lg-6">
                            <div class="featureWrap thePeopleWrap">
                                <div class="featureBox thePeople">
                                    <div class="personDetails">
                                        <a href="<?php the_permalink(); ?>"><img src="<?php echo $mainImage[0]; ?>" class="img-responsive center-block" alt="" /></a>
                                        <h3><?php the_title(); ?></h3>
                                        <?php if (get_field('person_position')) { ?>
                                            <p class="position"><strong><?php the_field('person_position'); ?></strong></p>
                                        <?php } ?>
                                        <a href="<?php the_permalink(); ?>" class="butn sz__sml fill__blue">More Details</a>
                                    </div>
                                </div>
                            </div>
                        </div> 
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
</div>