<div class="row">
    <!-- Content Pan -->
    <!-- Image / Gallery Pan -->
    <div class="col-xs-12 col-sm-7 col-sm-push-5 galleryGrid">
        <div class="ggWrap">
            <div class="row">
                <!-- Focus Image -->
                <div class="col-xs-12 mainFocus">
                    <div class="mainSlider">
                        <ul class="slides">
                            <?php
                            $sliderCount = count(get_field('image_slider'));
                            while (have_rows('image_slider')) {
                                the_row();
                                $mainImage = wp_get_attachment_image_src(get_sub_field('image'), "banner-images", false) 
                                        ? wp_get_attachment_image_src(get_sub_field('image'), 'banner-images', false) : array("https://dummyimage.com/1200x610/cccccc/000000.jpg&text=Pending+");
                                // use $sliderCount to put arrows in if needed
                                ?>

                                <li style="background-image: url(<?php echo $mainImage[0]; ?>);"></li>

                            <?php } ?>
                        </ul>
                    </div>
                </div>

                <!-- Slider Grid -->
                <?php
                if (have_rows('related_pages_repeater')) {
                    $pagesCount = 1;
                    ?>
                    <div class="col-xs-12 sliderSection">
                        <div class="flexslider">
                            <ul class="slides">
                                <?php
                                while (have_rows('related_pages_repeater')) {
                                    the_row();
                                    $page = get_sub_field('related_page');
                                    $image = wp_get_attachment_image_src(get_post_thumbnail_id($page), "slider-images", false) 
                                            ? wp_get_attachment_image_src(get_post_thumbnail_id($page), 'slider-images', false) : array("https://dummyimage.com/1200x1200/cccccc/000000.jpg&text=Pending+");
                                    if ($pagesCount == 1 || $pagesCount == 4) {
                                        $classes = 'weddings';
                                    } elseif ($pagesCount == 2 || $pagesCount == 5) {
                                        $classes = 'accommodation';
                                    } else {
                                        $classes = 'dining';
                                    }
                                    ?>
                                    <li class="<?php echo $classes; ?>" style="background-image: url(<?php echo $image[0]; ?>);">
                                        <a href="<?php echo get_the_permalink($page); ?>"></a>
                                        <div>
                                            <h3><?php echo get_the_title($page); ?></h3>
                                            <p><?php echo wp_trim_words(get_post_field('post_content', $page), 10, '..'); ?></p>
                                            <a href="<?php echo get_the_permalink($page); ?>">View More</a>
                                        </div>	
                                    </li>
                                    <?php
                                    $pagesCount++;
                                }
                                ?>

                            </ul>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="col-xs-12 col-sm-5 contentGrid">
        <div class="cgWrap" id="contentHome">
            <div class="hpBoxWrap text-center">
                <div>
                    <img src="<?php echo \Roots\Sage\Assets\asset_path('images/hpPanLogo.jpg'); ?>" alt="Balbirnie House Logo" />
                    <h2>One of the country's<br />finest small luxury hotels</h2>
                </div>
            </div>
			
            <?php the_content(); ?>
			
            <?php if (have_rows('buttons')) { ?>
                <div class="row homepageButtons" style="margin: 0 auto;">
                    <?php
                    $count = 0;
                    $fillClasses = ['fill__blue','fill__purp','fill__aqua'];
                    while (have_rows('buttons')) {
                        $fillClass = $fillClasses[$count];
                        the_row();
                        
                        if(get_sub_field('use_external_url_for_link')){
                            $link = get_sub_field('external_link');
                            $tgt='_blank';
                        }else{
                            $link = get_sub_field('page_link');
                            $tgt = '_self';
                        }
                        ?>

                        <div class="col-xs-12 col-sm-6 text-center">
                            <a class="butn sz__lrg <?= $fillClass; ?> center" target="<?=$tgt;?>" style="width: 100%;" href="<?= $link; ?>"> <?php the_sub_field('button_title'); ?></a>
                        </div>

                        <?php
                        $count++;
                        if($count>2){
                            $count=0;
                        };
                    }
                    ?>
                </div>
            <?php } ?>
        </div>
    </div>
</div>