<?php

$title = get_sub_field("title") ?? "";
$link = get_sub_field("link") ?? ""; 
$linkText = get_sub_field("link_text") ?? ""; 
$video = get_sub_field("video") ?? ""; 
$videoText = get_sub_field("video_text") ?? ""; 
$videoDescription = get_sub_field("video_description") ?? ""; 
$videoLink = get_sub_field("video_link") ?? ""; 
$videoLinkText = get_sub_field("video_link_text") ?? ""; 


?>
<section class="latest_media_section">
    <div class="latest_media_section-inner">
        <div class="title d-lg-block d-none">
            <h2><?= $title ?></h2>
            <a class="link view-more" href="<?= $link ?>"><?= $linkText ?></a>
        </div>
        <div class="latest-left container">
            <div class="row">
                <div class="video-container order-2 order-md-2">
                    <iframe src="<?= $video ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
                <?php if ($videoText !== "") { ?>
                    <p class="video-title order-1 order-md-1"><?= $videoText ?></p>
                <?php } ?>
                <p class="video-title order-3 order-md-3"><?= $videoDescription ?></p>
            </div>
        </div>
        <div class="latest-right">
            <?php if (have_rows("related_videos")) : ?>
                <?php while (have_rows("related_videos")) : the_row(); ?>
                <?php
                    $relatedVideoSrc = get_sub_field("video") ?? "";
                    $relatedVideoText = get_sub_field("video_text") ?? "";
                    $relatedVideoLink = get_sub_field("video_link") ?? "";
                    $relatedVideoLinkText = get_sub_field("video_link_text") ?? "";
                ?>
                    <div class="related-video-container">
                        <iframe src="<?= $relatedVideoSrc ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <div class="videoInfo">
                            <p><?= $relatedVideoText ?></p>
                            <?php if ($relatedVideoLink !== "") { ?>
                                <a href="<?= $relatedVideoLink ?>"><?= $relatedVideoLinkText ?></a>
                            <?php } ?>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php endif; ?>
            <div class="viewAll">
                <?php if ($videoLink !== "") { ?>
                    <a href="<?= $videoLink ?>"><?= $videoLinkText ?></a>
                <?php } ?>
            </div>
        </div>
    </div>
</section>
