<?php
    $headerImageMobile = get_field("header_image_mobile") ?? "";
    $headerImageTablet = get_field("header_image_tablet") ?? "";
    $headerImageDesktop = get_field("header_image_desktop") ?? "";
    $headerMobileLogoColor = get_field("mobile_logo_color") ?? "";
    $headerDesktopLogoColor = get_field("desktop_logo_color") ?? "";

    $mobileLogoColor = "";
    $desktopLogoColor = "";

    if ($headerMobileLogoColor == "light") {
        $mobileLogoColor = "-white";
    }
    if ($headerDesktopLogoColor == "light") {
        $desktopLogoColor = "-white";
    }
    if ($headerImageMobile == "") {
        $headerImageMobile = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
    if ($headerImageTablet == "") {
        $headerImageTablet = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
    if ($headerImageDesktop == "") {
        $headerImageDesktop = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
?>

<div class="header-nav-container <?= $headerType ?>">
    <nav class="header-nav" style="">
        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
            <img class="mobile" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $mobileLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
            <img class="tablet" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $desktopLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <i class="far fa-bars"></i>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation mobile ' . $headerMobileLogoColor]);
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation desktop ' . $headerDesktopLogoColor]);
            }
            ?>

            <ul class="contact">
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
                <?php if (get_field('contact_email_address', 'option')) { ?>
                <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </nav>
    <?php if (!is_front_page()) { ?>
        <div class="tagline">
            <h1><?= post_type_archive_title(); ?></h1>
        </div>
    <?php } ?>
    <div class="header-image-container">
        <img class="header-image-mobile" src="<?= $headerImageMobile ?>"></img>
        <img class="header-image-tablet" src="<?= $headerImageTablet ?>"></img>
        <img class="header-image-desktop" src="<?= $headerImageDesktop ?>"></img>
    </div>
</div>
