<?php
namespace Blue2\Scruffy;

use Blue2\Scruffy\Controllers\SearchController;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu',
            'menu-1' => 'Menu 1',
            'menu-2' => 'Menu 2',
            'menu-3' => 'Menu 3',
            'menu-4' => 'Menu 4',
            'menu-5' => 'Menu 5',
            'menu-6' => 'Menu 6'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        // Empty
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'registerTaxonomies']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        new SearchController();
    }

    public function registerTaxonomies()
    {
        new Taxonomy\Type();
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Team::registerPostType();
        Post\Documents::registerPostType();
    }

    public function customImageSizes()
    {
        add_image_size('portrait-card', 406, 600, true);
    }
}