const map = () => {
    //Google Maps
    const google = window.google;
    const locations = $('#map').data('operations');
    let mapLng = $('#map').data('map-center-lng');
    let mapLat = $('#map').data('map-center-lat');
    let mapZoom = $('#map').data('map-zoom');

    if (mapLng !== '' && mapLat !== '') {
        mapLng = $('#map').data('map-center-lng');
        mapLat = $('#map').data('map-center-lat');
    } else {
        mapLng = 0;
        mapLat = 0;
        $('.map-section').addClass('inactive');
    }
    if (mapZoom === '') {
        mapZoom = 7;
    }

    if ($(window).width() < 992) {
        mapZoom = 5;
    }

    const uluru = { lat: parseInt(mapLat, 10), lng:parseInt(mapLng, 10) };
    const map = new google.maps.Map(document.getElementById('map'), {
        zoom: mapZoom,
        center: uluru,
        fullscreenControl: false,
        mapTypeControl: false,
        zoomControl: false,
        gestureHandling: 'greedy',
        scrollwheel: false,
        streetViewControl: false,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.SMALL,
            position: google.maps.ControlPosition.TOP_RIGHT
        },
        styles : [
            {
                elementType: 'labels',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'administrative',
                elementType: 'geometry',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'administrative.land_parcel',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'administrative.neighborhood',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'landscape',
                stylers: [
                    {
                        color: '#1F2945'
                    }
                ]
            },
            {
                featureType: 'poi',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'road',
                elementType: 'labels.icon',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'transit',
                stylers: [
                    {
                        visibility: 'off'
                    }
                ]
            },
            {
                featureType: 'water',
                stylers: [
                    {
                        color: '#FFFFFF'
                    }
                ]
            }
        ]
    });

    $('.fa-minus').on('click', () => {
        map.setZoom(map.getZoom() - 1);
    });

    $('.fa-plus').on('click', () => {
        map.setZoom(map.getZoom() + 1);
    });


    const infowindow = new google.maps.InfoWindow;

    let marker;
    let i;

    for (i = 0; i < locations.length; i++) {
        if (locations[i][1] !== '' && locations[i][1] !== '') {
            marker = new google.maps.Marker({
                position : new google.maps.LatLng(locations[i][2], locations[i][1]),
                map
            });
        }

        google.maps.event.addListener(marker, 'click', (function(marker, i) {
            return function() {
                if (locations[i][3] === '') {
                    infowindow.setContent(locations[i][0]);
                } else {
                    infowindow.setContent(`<a href='${locations[i][3]}'>${locations[i][0]}</a>`);
                }
                infowindow.open(map, marker);
            };
        }(marker, i)));
    }
};

export default map;
