const common = () => {
    console.log('This gets run on every page and is exported as the default funciton. This will require a function call to run');

    $(window).scroll(() => {
        const elementTarget = $('#header-nav');
        const bottomOfTargetElement = elementTarget.position().top + elementTarget.outerHeight(true);
        const stickyNav = $('#sticky-header');
        if ($(window).scrollTop() > bottomOfTargetElement) {
            console.log('heretest');
            if (!stickyNav.hasClass('stuck')) {
                stickyNav.addClass('stuck');
            }
        } else {
            if (stickyNav.hasClass('stuck')) {
                stickyNav.removeClass('stuck');
            }
        }
    });

    const $hamburger = $('.hamburger');
    if ($hamburger) {
        // eslint-disable-next-line no-unused-vars
        $hamburger.on('click', _e => {
            $hamburger.toggleClass('is-active');
        });
    }

    const iframe1 = document.getElementById('iframe1');
    const iframe2 = document.getElementById('iframe2');

    function iframe1function() {
        document.getElementById('iframe1').className = 'active';
        document.getElementById('iframe2').className = '';
        document.getElementById('bahamasIframe').className = 'active';
        document.getElementById('bahamasIframe2').className = '';
    }

    function iframe2function() {
        document.getElementById('iframe1').className = '';
        document.getElementById('iframe2').className = 'active';
        document.getElementById('bahamasIframe').className = '';
        document.getElementById('bahamasIframe2').className = 'active';
    }

    if (iframe1) {
        iframe1.addEventListener('click', iframe1function);
        iframe1function();
        iframe2.addEventListener('click', iframe2function);
        iframe2function();
    }

    //Google Maps
    const google = window.google;
    const locations = $('#map').data('operations');
    let mapLng = $('#map').data('map-center-lng');
    let mapLat = $('#map').data('map-center-lat');
    let mapZoom = $('#map').data('map-zoom');

    if (mapLng !== '' && mapLat !== '') {
        mapLng = $('#map').data('map-center-lng');
        mapLat = $('#map').data('map-center-lat');
    } else {
        mapLng = 0;
        mapLat = 0;
        $('.map-section').addClass('inactive');
    }
    if (mapZoom === '') {
        mapZoom = 7;
    }

    if ($(window).width() < 992) {
        mapZoom = 5;
    }

    const uluru = { lat: parseInt(mapLat, 10), lng:parseInt(mapLng, 10) };
    const mapElement = document.getElementById('map');
    if (mapElement) {
        const map = new google.maps.Map(document.getElementById('map'), {
            zoom: mapZoom,
            center: uluru,
            fullscreenControl: false,
            mapTypeControl: false,
            zoomControl: false,
            gestureHandling: 'greedy',
            scrollwheel: false,
            streetViewControl: false,
            zoomControlOptions: {
                style: google.maps.ZoomControlStyle.SMALL,
                position: google.maps.ControlPosition.TOP_RIGHT
            },
            styles : [
                {
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#f5f5f5'
                        }
                    ]
                },
                {
                    elementType: 'labels.icon',
                    stylers: [
                        {
                            visibility: 'off'
                        }
                    ]
                },
                {
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#616161'
                        }
                    ]
                },
                {
                    elementType: 'labels.text.stroke',
                    stylers: [
                        {
                            color: '#f5f5f5'
                        }
                    ]
                },
                {
                    featureType: 'administrative.land_parcel',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#bdbdbd'
                        }
                    ]
                },
                {
                    featureType: 'landscape.natural',
                    elementType: 'geometry.fill',
                    stylers: [
                        {
                            color: '#043d58'
                        }
                    ]
                },
                {
                    featureType: 'poi',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#eeeeee'
                        }
                    ]
                },
                {
                    featureType: 'poi',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#757575'
                        }
                    ]
                },
                {
                    featureType: 'poi.park',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#e5e5e5'
                        }
                    ]
                },
                {
                    featureType: 'poi.park',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#9e9e9e'
                        }
                    ]
                },
                {
                    featureType: 'road',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#ffffff'
                        }
                    ]
                },
                {
                    featureType: 'road.arterial',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#757575'
                        }
                    ]
                },
                {
                    featureType: 'road.highway',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#dadada'
                        }
                    ]
                },
                {
                    featureType: 'road.highway',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#616161'
                        }
                    ]
                },
                {
                    featureType: 'road.local',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#9e9e9e'
                        }
                    ]
                },
                {
                    featureType: 'transit.line',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#e5e5e5'
                        }
                    ]
                },
                {
                    featureType: 'transit.station',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#eeeeee'
                        }
                    ]
                },
                {
                    featureType: 'water',
                    stylers: [
                        {
                            color: '#ffffff'
                        },
                        {
                            visibility: 'on'
                        },
                        {
                            weight: 8
                        }
                    ]
                },
                {
                    featureType: 'water',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#c9c9c9'
                        }
                    ]
                },
                {
                    featureType: 'water',
                    elementType: 'geometry.fill',
                    stylers: [
                        {
                            color: '#ffffff'
                        }
                    ]
                },
                {
                    featureType: 'water',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#9e9e9e'
                        }
                    ]
                }
            ]
        });

        // eslint-disable-next-line no-inner-declarations
        function myZoomOut() {
            map.setZoom(map.getZoom() - 1);
        }
        // eslint-disable-next-line no-inner-declarations
        function myZoomIn() {
            map.setZoom(map.getZoom() + 1);
        }
        document.getElementById('minus').onclick = function() {myZoomOut();};
        document.getElementById('plus').onclick = function() {myZoomIn();};

        let marker;
        let i;

        for (i = 0; i < locations.length; i++) {
            if (locations[i][1] !== '' && locations[i][1] !== '') {
                marker = new google.maps.Marker({
                    position : new google.maps.LatLng(locations[i][2], locations[i][1]),
                    icon : 'https://d1ssu070pg2v9i.cloudfront.net/pex/bahamas/2020/08/05222621/bahamas-pin.png',
                    map
                });
            }

            google.maps.event.addListener(marker, 'click', (function(marker, i) {
                return function() {
                    $('[id*="panel-"]').each(function() {
                        if (!$(this).hasClass('hide')) {
                            $(this).addClass('hide');
                        }
                    });
                    $(`#panel-${i}`).removeClass('hide');
                };
            }(marker, i)));
        }
    }
    console.log('here');
    // eslint-disable-next-line no-inner-declarations
    function expandmenu() {
        console.log('here');
        if ($('.menu-container ul').hasClass('expanded')) {
            $('.menu-container ul').removeClass('expanded');
            $('#minusBut').removeClass('show');
            $('#plusBut').addClass('show');
        } else {
            $('.menu-container ul').addClass('expanded');
            $('#minusBut').addClass('show');
            $('#plusBut').removeClass('show');
        }
    }
    const insection = document.getElementById('inSection');
    if (insection) {
        insection.onclick = function() {expandmenu();};
    }

    window.addEventListener('message', event => {
        const frames = document.getElementsByTagName('iframe');
        for (let i = 0; i < frames.length; i++) {
            if (frames[i].contentWindow === event.source) {
                jQuery(frames[i]).height(event.data);
                break;
            }
        }
    });
};

console.log('Any plain javascript will instantly run from an imported file');

export default common;
