<?php
$title = get_sub_field("title") ?? "";
$category = get_sub_field("category") ?? "";
$limit = get_sub_field("limit") ?? "";
$Link = get_sub_field("link") ?? "";
$limitCounter = 0;
if ($limit == "") {
    $limit = 999;
}
?>

<section class="latest_documents_section">
    <div class="latest_documents_section-inner">
        <div class="title">
            <h2><?= $title ?></h2>
            <?php echo $Link !== "" ? "<a class='view-more' href='". $Link ."'>View All</a>" : "" ?>
        </div>
        <?php
            $args = [
                'post_type'=> 'documents',
                'tax_query' => [
                    [
                        'taxonomy' => 'type',
                        'field' => 'term_id',
                        'terms' => $category,
                    ],
                ],
            ];

            $the_query = new WP_Query( $args );
            ?>
            <div class="documents-container">
            <?php
            if($the_query->have_posts() ) {
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    $title = get_the_title();
                    $date_format = get_option( 'date_format' );
                    $date = get_the_date( $date_format );
                    $fileLink = get_field('documents');
                    if (!(strpos($fileLink, 'http') !== false)) {
                        $fileLink = get_permalink($fileLink);
                    }
                    $documentTerms = wp_get_post_terms($post->ID,'type');
                    if ($documentTerms[0]->name !== "Proposed Merger") {
                    ?>
                        <div class="documents">
                            <div class="info">
                                <p class="date"><?= $date ?></p>
                                <h2><?= $title ?></h2>
                                <a target="_blank" href="<?= $fileLink ?>">View Document</a>
                            </div>
                        </div>
                    <?php
                    $limitCounter++;
                    if ($limit == $limitCounter){
                        break;
                    }
                    }
                }
                wp_reset_postdata();
            };
            ?>
            </div>
    </div>
</section>
