<?php
$title = get_sub_field("title") ?? "";
$category = get_sub_field("category") ?? "";
$limit = get_sub_field("limit") ?? "";
if ($limit == "") {
    $limit = 999;
}
$withThumnails = get_sub_field("with_thumbnails") ?? "";
$thumbnailClass = "";
if ($withThumnails) {
    $thumbnailClass = "withThumbnail";
}
?>

<section class="job_opportunities_section">
    <div class="job_opportunities_section-inner">
        <div class="title">
            <h2><?= $title ?></h2>
        </div>
        <div class="jobs-container">
        <?php
            $jobs = get_posts(['category' => $category]);
            $limitCounter = 1;
            $aosDelayCounter = 0;
            if ($jobs) {
                foreach ($jobs as $jobsPost) {
                    $jobsPostID = $jobsPost->ID;
                    $title = get_the_title($jobsPostID);
                    $date_format = get_option( 'date_format' );
                    $date = get_the_date( $date_format, $jobsPostID );
                    $permaLink = get_permalink($jobsPostID);
                    $featured = get_the_post_thumbnail_url($jobsPostID) ?? "";
                    if ($featured == "") {
                        $featuredImage = get_template_directory_uri() . "/dist/images/bpc-placeholder.jpg";
                    } else {
                        $featuredImage = $featured;
                    }
                    
                    ?>
                        <div class="jobs" data-aos="fade-up" data-aos-delay="<?= $aosDelayCounter ?>">
                            <?php 
                            if ($withThumnails) {
                                ?>
                                    <img src="<?= $featuredImage ?>"></img>
                                <?php
                            }
                            ?>
                            <div class="info">
                                <p class="date"><?= $date ?></p>
                                <h2><?= $title ?></h2>
                                <a class="<?= $thumbnailClass ?>" href="<?= $permaLink ?>">View</a>
                            </div>
                        </div>
                    <?php
                    if ($limit == $limitCounter){
                        break;
                    }
                    $limitCounter++;
                    $aosDelayCounter += 300;
                }
            } else {
                ?>
                <p>Unfortunately, there are no current open opportunities at BPC.</p>
                <?php
            }
        ?>
        </div>
    </div>
</section>