<?php
$args = [
    'post_type' => 'page',
    'posts_per_page' => -1,
    'post_parent' => get_the_id(),
    'order' => 'ASC',
    'orderby' => 'menu_order'
];
$subPages = new WP_Query($args);

$title = get_field("title") ?? "";
$text = get_field("text") ?? "";
$link = get_field("link") ?? "";
$linkText = get_field("link_text") ?? "";
$horizontalText = get_field("horizontal_text") ?? "";

if( have_rows('operation_locations') ) {
    $operations = [];
    while (have_rows('operation_locations')) {
        the_row();
        array_push($operations, [get_sub_field('title'), get_sub_field('longitude'), get_sub_field('latitude'), get_sub_field('link')]);
    }
}
?>

<div class="custom-operations-template">

    <div class="map-area">

        <div class="custom-controls">
            <ul>
                <li><i class="fas fa-plus"></i></li>
                <li><i class="fas fa-minus"></i></li>
            </ul>
        </div>

        <div class="title-panel">
            <div class="horiz">
            </div>
            <div class="horiz-text">
                <p><?= $horizontalText ?></p>
            </div>
            <h2 class="title"><?= $title ?></h2>
            <p class="text"><?= $text ?></p>
            <a class="link" href="<?= $link ?>"><?= $linkText ?></a>
        </div>

        <div id="map" data-map-zoom="<?php the_field('map_zoom') ?>" data-map-center-lng="<?php the_field('map_center_lng') ?>" data-map-center-lat="<?php the_field('map_center_lat') ?>" data-map-zoom="" data-operations="<?= htmlspecialchars(json_encode($operations)); ?>"></div>

        <?php if ($subPages->have_posts()) { ?>
            <div class="container overlay-container">
                <div class="map-overlay-block">
                    <div class="operation-sub-pages">
                        <?php while ( $subPages->have_posts() ) {
                            $subPages->the_post(); ?>
                            <div class="sub-page">
                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?> <i class="fas fa-chevron-right"></i></a></h2>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

    


</div>
