<?php get_header(); ?>
<?php while (have_posts()) : the_post(); ?>
    <div class="single-post">
        <div class="bahamas-container">
            <div class="main">
                <div class="post-content">
                    <h1 class="page-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>

                    <div class="the-content">
                        <?php
                        the_content();
                        $type = get_post_type();

                        if ($type == "documents") {
                            $postId = get_the_id();
                            $documentFile = get_field('documents', $postId);
                        }
                        ?>
                        <div class="share-links">
                            <?php
                            echo !$type == "documents" ? '<p><i class="far fa-share-alt"></i> Share this article</p>' : '<p>View this <a href="' . $documentFile . '">document</a></p>';
                            ?>
                            <div class="addthis_inline_share_toolbox"></div>
                        </div>
                    </div>
                </div>
                <div class="latest-section">
                    <div class="latest-video">
                        <h2>Latest Video</h2>
                        <iframe src="<?php the_field('latest_video', 'option'); ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <div class="date"></div>
                        <div class="text"></div>
                        <a target="_blank" href="<?php the_field('latest_video', 'option'); ?>">Watch Video</a>
                    </div>
                    <div class="latest-presentation">
                        <h2>Latest Presentation</h2>
                        <iframe src="<?php the_field('latest_presentation', 'option'); ?>" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        <div class="date"></div>
                        <div class="text"></div>
                        <a target="_blank" href="<?php the_field('latest_presentation', 'option'); ?>">View Presentation</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endwhile; ?>
<?php get_footer(); ?>