<?php
$var = file_get_contents("https://polaris.brighterir.com/public/bahamas_petroleum_company/data_table/share_price_widget_small");
$afterTag = substr($var, strpos($var, "<span class=\"data\">") + 1);
$before = explode("</span>", $afterTag, 2);
$first = $before[0];
$sharePrice = substr($first, -4);
$shareDate = new \DateTime('now');
$shareDate = $shareDate->format('d/m/Y');
?>

<section class="three-panels-section">
    <div class="three-panels-section-inner">
        <div class="panel">
            <h2 class="title">Share Price</h2>
            <p class="date"><?= $shareDate ?></p>
            <p class="stat"><?= $sharePrice ?></p>
            <a href="/investor-relations/share-price-performance/" class="link">Share Price Performance</a>
        </div>
        <div class="panel">
            <h2 class="title">Latest Regulatory News</h2>
            <iframe src="https://polaris.brighterir.com/public/bahamas_petroleum_company/news/rns_widget"></iframe>
            <a href="/investor-relations/regulatory-news/" class="link">View all</a>
        </div>
        <div class="panel financial">
            <?php
            $args = [
                'post_type'=> 'documents',
                'posts_per_page' => 5,
                'orderby' => 'date',
                'order'   => 'DESC',
                'type'    => 'financial-reports',
            ];
            $latestDoc = new WP_Query($args);

            ?><h2 class="title">Latest Financial Reports</h2><?php
            while($latestDoc->have_posts()){
                $latestDoc->the_post();
                $docLink = get_the_permalink();
                ?>
                    <div class="docContainer">
                        <p class="date"><?= get_the_date('d/m/Y'); ?></p>
                        <a class="titleLink" href="<?= "text" ?>"><p class="tag"><?= get_the_title(); ?></p></a>
                    </div>
                <?php
            }
            wp_reset_query();
            ?>
            <a href="/investor-relations/financial-reports/" class="link">View all</a>
        </div>
    </div>
</section>
