<?php
$title = get_sub_field("title") ?? "";
$category = get_sub_field("category") ?? "";
$limit = get_sub_field("limit") ?? "";
$Link = get_sub_field("link") ?? "";
if ($limit == "") {
    $limit = -1;
}
$withThumnails = get_sub_field("with_thumbnails") ?? "";
$thumbnailClass = "";
if ($withThumnails) {
    $thumbnailClass = "withThumbnail";
}
?>

<section class="latest_news_section">
    <div class="latest_news_section-inner">
        <div class="title">
            <h2><?= $title ?></h2>
            <?php echo $Link !== "" ? "<a class='view-more' href='". $Link ."'>View All</a>" : "" ?>
        </div>
        <div class="news-container">
        <?php
            $limitCounter = 1;
            $aosDelayCounter = 0;

            $args = [
                'post_type'=> 'post',
                'tax_query' => [
                    [
                        'taxonomy' => 'category',
                        'field' => 'term_id',
                        'terms' => $category,
                    ],
                ],
                'posts_per_page' => 12,
                'nopaging' => false,
                'paged' => $paged,
            ];

            global $wp_query; 

            $wp_query = new WP_Query( $args );
 
            if ( $wp_query->have_posts() ) {

                while ( $wp_query->have_posts() ) {
                    $wp_query->the_post();
                    
                    $newsPostID = get_the_ID();
                    $title = get_the_title($newsPostID);
                    $date_format = get_option( 'date_format' );
                    $date = get_the_date( $date_format, $newsPostID );
                    $permaLink = get_permalink($newsPostID);
                    $featured = get_the_post_thumbnail_url($newsPostID) ?? "";
                    if ($featured == "") {
                        $featuredImage = get_template_directory_uri() . "/dist/images/bpc-placeholder.jpg";
                    } else {
                        $featuredImage = $featured;
                    }
                    
                    ?>
                        <div class="news" data-aos="fade-up" data-aos-delay="<?= $aosDelayCounter ?>">
                            <?php 
                            if ($withThumnails) {
                                ?>
                                    <a href="<?= $permaLink ?>"><img src="<?= $featuredImage ?>"></img></a>
                                <?php
                            }
                            ?>
                            <div class="info">
                                <p class="date"><?= $date ?></p>
                                <h2><?= $title ?></h2>
                                <a class="<?= $thumbnailClass ?>" href="<?= $permaLink ?>">View</a>
                            </div>
                        </div>
                    <?php
                    if ($limit == $limitCounter){
                        break;
                    }
                    $limitCounter++;
                    $aosDelayCounter += 100;
                }
            }
            if ($limit > 12 || $limit == -1) {
            ?>
            <div class="page-links">
                <?php
                    previous_posts_link();
                    next_posts_link();
                ?>
            </div>
            <?php
            }
            wp_reset_query();
        ?>
        </div>
    </div>
</section>