<?php
    $menu = get_sub_field("menu") ?? "";
    $content = get_sub_field("content") ?? "";
    $separatorLine = get_sub_field("separator_lines");

    $separatorLine = $separatorLine ? "separatorLine" : "";
?>

<section class="content-section">
    <div class="content-section-inner">
        <div class="content-section-inner-container order-2 order-md-1 <?= $separatorLine ?>">
            <?= $content ?>
            <?php
                $iframeSrc = get_sub_field("iframe_src") ?? "";
            
                if ($iframeSrc !== "") {

                    $iframeheight = get_sub_field("iframe_height") ?? "";
                    $iframeSelector = get_sub_field("iframe_selector") ?? "";
                    $iframeSrc2 = get_sub_field("iframe_src_2") ?? "";
                    $iframeheight2 = get_sub_field("iframe_height_2") ?? "";
                    $iframeSelector2 = get_sub_field("iframe_selector_2") ?? "";

                    $iframeLink = get_sub_field("iframe_link") ?? "";

                    $isStacked = get_sub_field("stacked_iframe") ?? "";
                    $frameStack = "";
                    $frameActive = "active";

                    if ( $isStacked !== "" ) {
                        if ( $isStacked == true ) {
                            $frameStack = "stack";
                            $frameActive = "";
                        }
                    }
            ?>
                    <section class="iframe-section">
                        <div class="iframe-section-container">
                                    <?php
                                        if ($iframeSelector !== "" && $frameStack !== "stack") {
                                    ?>
                                    <div class="iframe-selector">
                                        <a id="iframe2" class="active"><?= $iframeSelector ?></a>
                                        <a id="iframe1" class=""><?= $iframeSelector2 ?></a>
                                    </div>   
                                    <?php
                                        }
                                    ?>   
                                    <iframe id="bahamasIframe2<?= $frameStack ?>" class="active" style="height: <?= $iframeheight ?>px" src="<?= $iframeSrc ?>"></iframe>
                                    <?php
                                        if ($iframeSrc2 !== "") {
                                    ?>
                                        <iframe id="bahamasIframe<?= $frameStack ?>" class="" style="height: <?= $iframeheight2 ?>px" src="<?= $iframeSrc2 ?>"></iframe>
                                    <?php
                                        }
                                    ?>
                                <?php echo $iframeLink !== "" ? "<a href='". $iframeLink ."'>View All</a>" : "" ?>
                        </div>
                    </section>
            <?php
                }
            ?>

            <?php
                $tableShortcode = get_sub_field("table_shortcode") ?? "";
            
                if ($tableShortcode !== "") {
                    ?>
                    <section class="section-table">
                        <div class="section-table-container">
                            <div class="section-table-container-inner">
                                <div class="table">
                                    <?php echo do_shortcode( get_sub_field('table_shortcode'), false ); ?>
                                </div>
                            </div>
                        </div>
                    </section>
                    <?php
                }
            ?>
            <?php
            $documentTitle = get_sub_field("document_title") ?? "";
            $documentCategory = get_sub_field("document_category") ?? "";
            $documentLimit = get_sub_field("document_limit") ?? "";
            $limitCounter = 0;
            if ($limit == "") {
                $limit = 999;
            }
            ?>

            <?php if ($documentCategory !== false) { ?>
            <section class="latest_documents_section">
                <div class="latest_documents_section-inner">
                    <div class="title">
                        <h2><?= $documentTitle ?></h2>
                    </div>
                    <?php
                        $args = [
                            'post_type'=> 'documents',
                            'tax_query' => [
                                [
                                    'taxonomy' => 'type',
                                    'field' => 'term_id',
                                    'terms' => $documentCategory,
                                ],
                            ],
                        ];

                        $the_query = new WP_Query( $args );
                        if($the_query->have_posts() ) {
                            while ( $the_query->have_posts() ) {
                                $the_query->the_post();
                                $title = get_the_title();
                                $date_format = get_option( 'date_format' );
                                $date = get_the_date( $date_format );
                                $fileLink = get_field('documents'); 
                                $documentTerms = wp_get_post_terms($post->ID,'type');
                                if ($documentTerms[0]->name !== "Proposed Merger") {
                                ?>
                                    <div class="documents">
                                        <div class="info">
                                            <p class="date"><?= $date ?></p>
                                            <h2><?= $title ?></h2>
                                            <a href="<?= $fileLink ?>">View Document</a>
                                        </div>
                                    </div>
                                <?php
                                $limitCounter++;
                                if ($documentLimit == $limitCounter){
                                    break;
                                }
                                }
                            }
                            wp_reset_postdata();
                        };
                    ?>
                </div>
            </section>
            <?php } ?>
        </div>
        <div class="menu-section order-1 order-md-2">
            <div class="menu-container">
                <p id="inSection">In This Section:<span><i id="plusBut" class="far fa-plus show"></i><i id="minusBut" class="far fa-minus"></i></span></p>
                <?php
                switch ($menu) {
                    case "menu1":
                        if (has_nav_menu('menu-1')) {
                            wp_nav_menu(['theme_location' => 'menu-1', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                    case "menu2":
                        if (has_nav_menu('menu-2')) {
                            wp_nav_menu(['theme_location' => 'menu-2', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                    case "menu3":
                        if (has_nav_menu('menu-3')) {
                            wp_nav_menu(['theme_location' => 'menu-3', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                    case "menu4":
                        if (has_nav_menu('menu-4')) {
                            wp_nav_menu(['theme_location' => 'menu-4', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                    case "menu5":
                        if (has_nav_menu('menu-5')) {
                            wp_nav_menu(['theme_location' => 'menu-5', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                    case "menu6":
                        if (has_nav_menu('menu-6')) {
                            wp_nav_menu(['theme_location' => 'menu-6', 'menu_class' => 'navigation desktop ']);
                        }
                        break;
                }
                ?>
            </div>
        </div>
    </div>
</section>