<?php
    $headerImageMobile = get_field("header_image_mobile") ?? "";
    $headerImageTablet = get_field("header_image_tablet") ?? "";
    $headerImageDesktop = get_field("header_image_desktop") ?? "";
    $headerMobileLogoColor = get_field("mobile_logo_color") ?? "";
    $headerDesktopLogoColor = get_field("desktop_logo_color") ?? "";
    $showTagline = get_field("show_tagline");

    $mobileLogoColor = "";
    $desktopLogoColor = "";

    if ($headerMobileLogoColor == "light") {
        $mobileLogoColor = "-white";
    }
    if ($headerDesktopLogoColor == "light") {
        $desktopLogoColor = "-white";
    }
    if ($headerImageMobile == "") {
        $headerImageMobile = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
    if ($headerImageTablet == "") {
        $headerImageTablet = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
    if ($headerImageDesktop == "") {
        $headerImageDesktop = get_template_directory_uri() . "/dist/images/BPC-beach-banner.jpg";
    }
?>
<?php
$headerType = get_field("header_type") ?? "";
if (is_404()) {
    $headerType = "internal";
} elseif ($headerType == "" || $headerType == "home" ) {
    $headerType = "";
} else {
    $headerType = "internal";
}
?>

<div class="header-nav-container <?= $headerType ?>">
    <nav class="header-nav" id="header-nav" style="">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img class="mobile" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $mobileLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
            <img class="tablet" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $desktopLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
        </a>
        <button class="hamburger hamburger--collapse" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="hamburger-box">
                <span class="hamburger-inner"></span>
            </span>
        </button>

        <?php get_search_form(); ?>

        <?php
        $socials = get_field('social_media_channels', 'option');
        if($socials) { ?>
            <div class="social">
                <?php foreach($socials as $social) { ?>
                    <div>
                        <a href="<?= $social['full_url']; ?>" target="_blank">
                            <i class="<?= $social['fa5_icon_class']; ?>"></i>
                        </a>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>



        <div class="share-price">
            <div class="share-price-inner">
                <iframe src="https://polaris.brighterir.com/public/bahamas_petroleum_company/data_table/share_price_widget_small"></iframe>
            </div>
        </div>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation mobile ' . $headerMobileLogoColor]);
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation desktop ' . $headerDesktopLogoColor]);
            }
            ?>

            <ul class="contact">
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
                <?php if (get_field('contact_email_address', 'option')) { ?>
                <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </nav>
    <?php if (!is_front_page() && $showTagline) { ?>
        <div class="tagline <?= $headerType ?>">
            <?php if (!is_single()) { ?>
                <h1><?= the_title(); ?></h1>
            <?php } else { ?>
                <h1><?= get_the_category()[0]->name ?></h1>
            <?php } ?>
        </div>
    <?php } ?>
    <div class="header-image-container">
        <img class="header-image-mobile" src="<?= $headerImageMobile ?>">
        <img class="header-image-tablet" src="<?= $headerImageTablet ?>">
        <img class="header-image-desktop" src="<?= $headerImageDesktop ?>">
    </div>
    <div class="sub-menu <?= $headerType ?>">
    <?php
        $pageTitle = get_the_title() ?? "";
        $parent = $post->post_parent;
        $parent_post = get_post($parent);
        $parent_post_title = $parent_post->post_title ?? "";
        $parent_post_link = get_post_permalink($parent);

        $parents_parent = $parent_post->post_parent;
        $parent_parent_post = get_post($parents_parent);
        $parents_parent_post_title = $parent_parent_post->post_title ?? "";
        $parents_parent_post_link = get_post_permalink($parents_parent);
        $parents_parent_post_title = $parents_parent_post_title == $pageTitle ? "" : $parents_parent_post_title;

        if (!$parent){
            $parent_post_title = "";
            $parents_parent_post_title = "";
        }
    ?>
        <p><?php if ($parents_parent_post_title !== "" && $parents_parent_post_title !== "Vision & Strategy") { ?>
            <a href="<?= $parents_parent_post_link ?>"><?= $parents_parent_post_title; ?></a>
        <?php } ?>
        <?php if ($parent_post_title !== "") { ?>  
            /  <a href="<?= $parent_post_link ?>"><?= $parent_post_title; ?></a>
        <?php } ?>
        <?php if ($pageTitle !== "") { ?>  
            /  <a href=""><?= $pageTitle; ?></a>
        <?php } ?></p>
    </div>
</div>

<div class="sticky-header" id="sticky-header">
    <nav class="header-nav" style="">
        <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>">
            <img class="mobile" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $mobileLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
            <img class="tablet" src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped<?= $desktopLogoColor ?>.png" alt="<?php bloginfo('name'); ?>" />
        </a>
        <button class="hamburger hamburger--collapse" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="hamburger-box">
                <span class="hamburger-inner"></span>
            </span>
        </button>
        <?php get_search_form(); ?>
        <div class="share-price">
            <div class="share-price-inner">
                <iframe src="https://polaris.brighterir.com/public/bahamas_petroleum_company/data_table/share_price_widget_small"></iframe>
            </div>
        </div>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <?php
            if (has_nav_menu('main_menu')) {
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation mobile ' . $headerMobileLogoColor]);
                wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation desktop ' . $headerDesktopLogoColor]);
            }
            ?>

            <ul class="contact">
                <?php if (get_field('contact_phone_number', 'option')) { ?>
                <li><a href="tel:<?php the_field('contact_phone_number', 'option'); ?>"><i class="far fa-phone"></i> <?php the_field('contact_phone_number', 'option'); ?></a></li>
                <?php } ?>
                <?php if (get_field('contact_email_address', 'option')) { ?>
                <li><a href="mailto:<?php the_field('contact_email_address', 'option'); ?>"><i class="far fa-envelope-open"></i> <?php the_field('contact_email_address', 'option'); ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </nav>
</div>

<?php

// echo "HERE";
// echo "<pre>";
// $results = wp_remote_get("https://cloud.iexapis.com/stable/stock/BPC/financials?token=Tsk_ef8991fa5ae94449820eb376f30ae063&period=annual ");
// var_dump($results);

?>
