<?php
$companyAddress = get_field('address', 'option') ?? "";
$companyName = get_field('company_name', 'option') ?? "";
$footerTextLine = get_field('footer_text_line', 'option') ?? "";
?>

<footer class="site-footer">
    <div class="site-footer-inner container-fluid">
        <div class="row">
            <div class="footer-logo">
                <img src="<?=get_template_directory_uri();?>/dist/images/bahamas-logo-cropped-white.png">
            </div>
            <nav class="navigation-container">
                <?php
                if (has_nav_menu('main_menu')) {
                    wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'navigation']);
                }
                ?>
            </nav>
            <div class="company-details">
                <span><strong>Head Office</strong><br/>
                <span><?= $companyAddress ?></span>
                </span>
            </div>
            <div class="copyright credit">
                <div class="blog-info">
                    <a class="reg-link" href="/email-alerts/">Register for updates</a>
                    <p>&copy; <?php echo date("Y"); ?> <?= $companyName ?></p>
                    <p><?= $footerTextLine ?></p>
                </div>
                <div class="blue2">
                    <p>Website by </p>
                    <?php echo do_shortcode( '[blue2_logo type="light"]' ); ?>
                </div>
            </div>
            <div class="footer-copyright-menu">
                <?php
                if (has_nav_menu( 'footer_menu' )) {
                    wp_nav_menu(['theme_location' => 'footer_menu', 'menu_class' => '']);
                }
                ?>
            </div>

        </div>
    </div>
    <div class="footer-image-container">
        <img src="<?= get_template_directory_uri() . "/dist/images/footer-image.jpg"?>">
    </div>
</footer>
