import '@babel/polyfill'; // Required for build
import load from './loader'; // Required for loading files dynamically
import 'bootstrap/js/dist/util'; // All Bootstrap JS requires Util
import 'bootstrap/js/dist/collapse'; // Used for nav collapse functionality
import '@fortawesome/fontawesome-pro/js/all.min.js';
import AOS from 'aos';
import 'aos/dist/aos.css';

import Swiper from 'swiper/dist/js/swiper.js';
import 'swiper/dist/css/swiper.css';

import common from './common';
/*
    Basic Event Routing
    -------------------
    Switch on body class that gets applied either due to page, post type or page template
    Replace '-' in the class name with '_'
*/
const route = className => {
    switch (className) {

        case 'single_post':
            load('./post');
            break;
        case 'template_operations':
            load('./map');
            break;

    }
};

// Fire events once document has loaded
document.addEventListener('DOMContentLoaded', () => {
    common(); // Run common code on every page

    AOS.init();

    const bodyClasses = document.body.className // Get all body classes,
        .replace(/-/g, '_') // replace dashes with underscores,
        .replace(/page_template_/g, '') // remove prefix 'page_template' from template classes, &
        .split(/\s+/); // split on whitespace

    for (const value of bodyClasses) {
        route(value); // Run javascript for each body class
    }

    const swiperContainer = document.getElementsByClassName('swiper-container');

    if (swiperContainer) {
        new Swiper('.swiper-container', {
            slidesPerView: 5,
            spaceBetween: 30,
            loop: true,
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                320: {
                    slidesPerView: 1.2,
                    slidesPerGroup: 1,
                    spaceBetween: 10,
                },
                850: {
                    slidesPerView: 2.2,
                    slidesPerGroup: 1,
                    spaceBetween: 10,
                },
                1200: {
                    slidesPerView: 3.5,
                    slidesPerGroup: 1,
                },
                1400: {
                    slidesPerView: 4.5,
                    slidesPerGroup: 1,
                }
            }
        });
    }
    /* global google */

    const leftMap = document.getElementById('map-left');
    if (leftMap) {
        const mapLeft = new google.maps.Map(document.getElementById('map-left'), {
            center: { lat: 25.0726146, lng: -77.4447888 },
            zoom: 14,
            disableDefaultUI: true,
            styles: [
                {
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#EBE3CD'
                        }
                    ]
                },
                {
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#523735'
                        }
                    ]
                },
                {
                    elementType: 'labels.text.stroke',
                    stylers: [
                        {
                            color: '#F5F1E6'
                        }
                    ]
                },
                {
                    featureType: 'administrative',
                    elementType: 'geometry',
                    stylers: [
                        {
                            visibility: 'off'
                        }
                    ]
                },
                {
                    featureType: 'administrative',
                    elementType: 'geometry.stroke',
                    stylers: [
                        {
                            color: '#C9B2A6'
                        }
                    ]
                },
                {
                    featureType: 'administrative.land_parcel',
                    elementType: 'geometry.stroke',
                    stylers: [
                        {
                            color: '#DCD2BE'
                        }
                    ]
                },
                {
                    featureType: 'administrative.land_parcel',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#AE9E90'
                        }
                    ]
                },
                {
                    featureType: 'landscape.natural',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#DFD2AE'
                        }
                    ]
                },
                {
                    featureType: 'poi',
                    stylers: [
                        {
                            visibility: 'off'
                        }
                    ]
                },
                {
                    featureType: 'poi',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#DFD2AE'
                        }
                    ]
                },
                {
                    featureType: 'poi',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#93817C'
                        }
                    ]
                },
                {
                    featureType: 'poi.park',
                    elementType: 'geometry.fill',
                    stylers: [
                        {
                            color: '#A5B076'
                        }
                    ]
                },
                {
                    featureType: 'poi.park',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#447530'
                        }
                    ]
                },
                {
                    featureType: 'road',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#F5F1E6'
                        }
                    ]
                },
                {
                    featureType: 'road',
                    elementType: 'labels.icon',
                    stylers: [
                        {
                            visibility: 'off'
                        }
                    ]
                },
                {
                    featureType: 'road.arterial',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#FDFCF8'
                        }
                    ]
                },
                {
                    featureType: 'road.highway',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#F8C967'
                        }
                    ]
                },
                {
                    featureType: 'road.highway',
                    elementType: 'geometry.stroke',
                    stylers: [
                        {
                            color: '#E9BC62'
                        }
                    ]
                },
                {
                    featureType: 'road.highway.controlled_access',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#E98D58'
                        }
                    ]
                },
                {
                    featureType: 'road.highway.controlled_access',
                    elementType: 'geometry.stroke',
                    stylers: [
                        {
                            color: '#DB8555'
                        }
                    ]
                },
                {
                    featureType: 'road.local',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#806B63'
                        }
                    ]
                },
                {
                    featureType: 'transit',
                    stylers: [
                        {
                            visibility: 'off'
                        }
                    ]
                },
                {
                    featureType: 'transit.line',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#DFD2AE'
                        }
                    ]
                },
                {
                    featureType: 'transit.line',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#8F7D77'
                        }
                    ]
                },
                {
                    featureType: 'transit.line',
                    elementType: 'labels.text.stroke',
                    stylers: [
                        {
                            color: '#EBE3CD'
                        }
                    ]
                },
                {
                    featureType: 'transit.station',
                    elementType: 'geometry',
                    stylers: [
                        {
                            color: '#DFD2AE'
                        }
                    ]
                },
                {
                    featureType: 'water',
                    elementType: 'geometry.fill',
                    stylers: [
                        {
                            color: '#B9D3C2'
                        }
                    ]
                },
                {
                    featureType: 'water',
                    elementType: 'labels.text.fill',
                    stylers: [
                        {
                            color: '#92998D'
                        }
                    ]
                }
            ]
        });
        const marker = new google.maps.Marker({
            position: { lat: 25.072605, lng: -77.442601 },
            map: mapLeft,
        });

        marker.addListener('click', () => {
            window.open($('#directions-edinburgh').attr('href'), '_blank');
        });
    }
});
