<?php
$title = get_the_title();
$imageUrl = get_the_post_thumbnail_url();
$link = get_the_permalink();
$subInfo = get_field('sub_info');
$cardTitleOverride = get_field('card_title_override');

?>

<div class="col-md-6">
    <figure class="card-hover" data-aos="fade-up" data-aos-duration="1000">
        <img src="<?= $imageUrl; ?>" alt="<?= $title; ?>"/>
        <figcaption>
            <?php if($cardTitleOverride) { ?>
                <h2><?= $cardTitleOverride; ?></h2>
            <?php } else { ?>
                <h2><?= $title; ?></h2>
            <?php } ?>
            <a href="<?= $link; ?>" > <?php if($subInfo) { ?><span><?= $subInfo ?></span> <?php } ?></a>
        </figcaption>			
    </figure>
    <span class="frame-holder"></span>
</div>