<?php 
$featuredProject = get_field('featured_project', 'option');

if($featuredProject) {
    $title = $featuredProject->post_title;
    $imageUrl = get_the_post_thumbnail_url($featuredProject->ID);
    $link = get_the_permalink($featuredProject->ID);
    $subInfo = get_field('sub_info');
    $cardTitleOverride = get_field('card_title_override');
}
?>

<div class="col-12">
    <figure class="card-hover" >
        <img src="<?= $imageUrl; ?>" alt="<?= $imageAlt; ?>" />
        <figcaption>
            <?php if($cardTitleOverride) { ?>
                <h2><?= $cardTitleOverride; ?></h2>
            <?php } else { ?>
                <h2><?= $title; ?></h2>
            <?php } ?>
            <a href="<?= $link; ?>" ><?php if($subInfo) { ?><span><?= $subInfo ?></span> <?php } ?></a>
        </figcaption>			
    </figure>
</div>
