<header id="Top">
    <div class="container-fluid">
        <div class="row">
            <div class="col-6">
                <a href="<?php echo esc_url(home_url('/')); ?>" >
                    <img class="img-fluid logo" src="<?=get_template_directory_uri();?>/dist/images/avian-logo.svg" alt="<?php bloginfo('name'); ?>" >
                </a>
            </div>
            <div class="col-6">
                <button class="hamburger hamburger--spin trigger-overlay" type="button">
                    <span class="hamburger-box">
                        <span class="hamburger-inner"></span>
                    </span>
                </button>
            </div>
        </div>
    </div>
    <div class="overlay overlay-hugeinc close">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <a href="<?php echo esc_url(home_url('/')); ?>" >
                        <img class="img-fluid logo" src="<?=get_template_directory_uri();?>/dist/images/avian-logo-white.svg" alt="<?php bloginfo('name'); ?>" >
                    </a>
                </div>
            </div>
        </div>
        <div class="container">
            <div class="row d-flex align-items-end">
                <div class="col-md-6">
                    <nav>
                    <?php
                    if (has_nav_menu('main_menu')) {
                        wp_nav_menu(['theme_location' => 'main_menu', 'menu_class' => 'main-menu']);
                    }
                    ?>
                    </nav>
                </div>
                <div class="col-md-6 company-info">
                    <?= get_template_part('templates/parts/company-info'); ?>
                </div>
            </div>
        </div>
    </div>
</header>

<?php
$bannerActive = get_field('banner_active','option');

if(!isset($_COOKIE['banner-cookie']) && is_front_page() && $bannerActive){
    $bannerTitle = get_field('banner_title','option');
    $bannerContent = get_field('banner_content','option');

    ?>
    <div class="modal fade" id="bannerModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= $bannerTitle; ?></h5>
                    <div class="close-button close" data-dismiss="modal" aria-label="Close">
                        <i class="fal fa-times"></i>
                    </div>
                </div>
                <div class="modal-body">
                    <?= $bannerContent; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    
    <?php
    $path = parse_url(get_option('siteurl'), PHP_URL_PATH);
    $host = parse_url(get_option('siteurl'), PHP_URL_HOST);
    $expiry = strtotime('+1 day');
    setcookie('banner-cookie', 1, $expiry, '/', $host);
}
?>