<?php 
$mainImage = get_sub_field('main_image');
$edge = get_sub_field('edge_to_edge') ? 'True' : '';
?>

<section class="section section--cards <?php if ($edge == 'True') { ?>section--edge<?php } ?>">
    <div class="container-fluid container-fluid--step-in">
        <div class="row">
            <?php 
                if (have_rows('cards_to_display')) {
                ?>
                <?php while (have_rows('cards_to_display')) {
                    the_row();
                    $fullWidthCard = get_sub_field('full_width_card') ? 'True' : '';
                    ?>
                    <div class="col-6<?php if ($fullWidthCard == 'True') { ?> col-12<?php } ?>">                   
                    <?php if(get_sub_field('image_card')) { 
                        $imageCard = get_sub_field('image_card');
                    ?>
                        <img class="card--single-image img-fluid" src="<?= $imageCard['url']; ?>" alt="<?= $imageCard['alt']; ?>" data-aos="fade-up" data-aos-duration="1000" />
                        <span class="frame-holder"></span>
                    <?php } elseif (get_sub_field('video_card')) { 
                    ?>
                        <video class="card--single-video" autoplay loop muted controls width="100%" height="auto" data-aos="fade-up" data-aos-duration="1000">			
                            <source src="<?php the_sub_field('video_card'); ?>" type="video/mp4">		
                        </video>
                        <span class="frame-holder"></span>
                    <?php } elseif (get_sub_field('project_card')) { ?>
                        <figure class="card-hover" data-aos="fade-up" data-aos-duration="1000" >
                                <img src="<?=get_template_directory_uri();?>/dist/images/placeholder-1920-1080.jpg" alt="placeholder image"/>
                                <figcaption>
                                    <h2>Card project title</h2>
                                    <a href="#" ><span>Client name / service</span></a>
                                </figcaption>			
                        </figure>
                        <span class="frame-holder"></span>
                    <?php } ?>
                     </div>
                <?php } ?>
            <?php } ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>