<main>

    <?php get_template_part('templates/sections/banner_slide') ?>
    <section id="main" class="section section--lead-text background-primary">
            <div class="container-fluid">
                <div class="row"> 
                    <div class="col-md-7">
                        <div class="content h-inline">
                            <h1><?php the_field('inline_text_heading'); ?></h1>
                            <p><?php the_field('follow_on_leading_line'); ?></p>
                            <span class="inline-btn">
                                <a class="button button--text-build" href="<?php echo esc_url(home_url('/')); ?>project">
                                    <strong>Our Work</strong>
                                </a>
                            </span>
                        </div>
                    </div>
                    <div class="col-5">
                        <img data-aos="fade-right" data-aos-duration="1000" data-aos-delay="500" src="<?=get_template_directory_uri();?>/dist/images/a.svg" alt="avian a"/>
                    </div>  
                </div>
            </div>
    </section>
    <?php if (have_rows('feature_projects')) { ?>
    <?php while (have_rows('feature_projects')) {
        the_row();
        $featuredProjects = get_sub_field('projects');
    ?>
    <section class="section section--cards section--edge section--nudge-up" style="position:relative; z-index:100;">
        <div class="container-fluid container-fluid--step-in">
            <div class="row">
            <?php foreach($featuredProjects as $post) {
                    setup_postdata($post);
                    $subInfo = get_field('sub_info');
                    $cardTitleOverride = get_field('card_title_override');
                    ?>
                    <div class="col-md-6">
                        <figure class="card-hover" data-aos="fade-up" data-aos-duration="1000" >
                            <?php the_post_thumbnail( 'main-image', ['class' => 'img-fluid'] ); ?>
                            <figcaption>
                                <?php if($cardTitleOverride) { ?>
                                    <h2><?= $cardTitleOverride; ?></h2>
                                <?php } else { ?>
                                    <h2><?php the_title(); ?></h2>
                                <?php } ?>
                                <a href="<?php the_permalink(); ?>" > <?php if($subInfo) { ?><span><?= $subInfo ?></span> <?php } ?></a>
                            </figcaption>			
                        </figure>
                    </div>
                <?php } ?>
               <?php wp_reset_postdata(); ?>
            </div>            
        </div>
    </section>
        <?php } ?>
    <?php } ?>
    <?php get_template_part('templates/sections/logo_grid') ?>
    <?php get_template_part('templates/sections/feature_news_posts') ?>
</main>