<?php 
$map = get_field('map');
$mapTitle = get_field('map_title');
$mapContent = get_field('map_content');
$newsletterImage = get_field('newsletter_image');
$iconPath = get_stylesheet_directory_uri() . "/assets/images/a-marker.png";

$mapInfoPin = [
    "lat" => $map['lat'],
    "lng" => $map['lng'],
    "street_name" => $map['street_name'],
    "street_number" => $map['street_number'],
    "post_code" => $map['post_code'],
]
?>
<div class="custom-contact-page">
    <div class="container-fluid">
        <div class="row">
        <section class="map-section">
            <div class="map-internal-box">
                <h1 class="map-title"><?= $mapTitle; ?></h1>
                <div class="map-content"><?= $mapContent; ?></div>
                <div class="map-company-info">
                    <div class="w-100 address">
                        <p>Avian House</p>
                        <p>Brook Street</p>
                        <p>Broughty Ferry</p>
                        <p>Dundee DD5 1DJ</p>
                    </div>
                    <div class="w-100 contact-info">
                        <?= get_template_part('templates/parts/company-contact'); ?>
                    </div>
                <div class="map-social">
                    <?= get_template_part('templates/parts/social-channels'); ?>
                </div>
            </div>
            </div>
            <div id="map" class="map-container" data-map-info='<?= json_encode($mapInfoPin); ?>' data-icon-path='<?= $iconPath; ?>'>
            </div>
        </section>
        <section class="newsletter-section">
            <div class="newsletter-internal-box sign-up">
                <h4 class="newsletter-title">Keep up to date</h4>
                <p class="newsletter-content">Get all the latest news from Avian House straight to your inbox. Sign up below.</p>
                <form action="https://beeline.blue2.co.uk/t/r/s/ihddjrr/" method="post" id="subForm" _lpchecked="1">
                    <div class="input-group">
                        <input class="form-control" placeholder="Enter email address here" id="fieldEmail" name="cm-ihddjrr-ihddjrr" type="email" required="">
                        
                    <span class="input-group-btn">
                        <button class="button button--text-build g-recaptcha" data-sitekey="6LfUt7oZAAAAABLvP1WOufojk8QyKvgW6He1I3t8" type="submit"><span>S</span><span>u</span><span>b</span><span>m</span><span>i</span><span>t</span></button>
                    </span>
                    </div>
                </form>
            </div>
            <div class="offset-lg-6">
                <img class="img-fluid" src="<?=$newsletterImage['url'];?>">
            </div>
        </section>
        </div>
    </div>
</div>