<?php
namespace Blue2\Scruffy;

class Site extends \Blue2\Common\Site
{
    public function __construct()
    {
        parent::__construct();

        add_action('after_setup_theme', [$this, 'registerMenus']);
        add_filter('excerpt_more', [$this, 'tidyExcerpt']);

        $this->registerShortCodes();
        $this->registerFilters();
        $this->registerActions();
        $this->setupControllers();
    }

    public function registerMenus()
    {
        register_nav_menus([
            'main_menu' => 'Main Menu',
            'footer_menu' => 'Footer Menu'
        ]);
    }

    public function tidyExcerpt()
    {
        return ' &hellip; <a href="' . get_permalink() . '">Continued</a>';
    }

    private function registerShortCodes()
    {
        // Empty
    }

    private function registerFilters(){
        add_filter('acf/fields/google_map/api', [$this, 'myAcfGoogleMapApi']);
        add_filter('wp_enqueue_scripts', [$this, 'enqueueScripts']);
        add_filter( 'script_loader_tag', [$this, 'mindDeferAsyncScripts'], 10, 3 );
    }

    private function registerActions() {
        add_action('init', [$this, 'registerPostTypes']);
        add_action('init', [$this, 'addPostTypeOptionsPage']);
        add_action('init', [$this, 'customImageSizes']);
    }

    private function setupControllers(){
        //Empty
    }

    public function registerPostTypes()
    {
        Post\Event::registerPostType();
        Post\Project::registerPostType();
    }
    
    public function addPostTypeOptionsPage()
    {
        if (function_exists('acf_add_options_page')) {
            acf_add_options_page([
                'title' => 'Project Archive Settings',
                'parent' => 'edit.php?post_type=project',
                'capability' => 'edit_posts',
            ]);
        }
    }
    
    public function customImageSizes()
    {
        add_image_size('main-image', 1920, 1080, true);
        add_image_size('half-image', 960, 1080, true);
        add_image_size('social', 1200, 628, true);  
    }

    public function myAcfGoogleMapApi( $api ){
        $api['key'] = 'AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw';
        return $api;
    }
    public function enqueueScripts(){
        if(is_page_template('template-contact-page.php')) {
            wp_enqueue_script('google-maps', '//maps.googleapis.com/maps/api/js?key=AIzaSyAGsKZ5PP8iURMpB4kRQKcpLQps-szGeqw', ['jquery'], null, true);
        }
        wp_enqueue_script('add-this', '//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5579797d2e68a5fd', [], null, true);
        wp_enqueue_script('recaptcha', 'https://www.google.com/recaptcha/api.js', [], null, true);
    }
    function mindDeferAsyncScripts( $tag, $handle, $src ) {
        $defer = array( 
          'add-this',
        );
        if ( in_array( $handle, $defer ) ) {
           return '<script src="' . $src . '" defer="defer" async="async" type="text/javascript"></script>' . "\n";
        }
          
          return $tag;
      } 
}