import { Swiper, Autoplay } from 'swiper';

const home = () => {
    Swiper.use([Autoplay]);
    new Swiper('.swiper--featured', {
        pagination: {
            el: '.swiper-pagination',
        },
        slidesPerView: 1.1,
        loop: false,
        autoplay: {
            delay: 3000,
            stopOnLastSlide: true
        },
        on:{
            init: function() { //eslint-disable-line
                this.autoplay
                    .start();
            }
        },
        breakpoints: {
            320: {
                slidesPerView: 1,
                slidesPerGroup: 1
            },
            768: {
                slidesPerView: 1.2,
                slidesPerGroup: 1.2
            },
            1200: {
                slidesPerView: 1.1,
                slidesPerGroup: 1.1
            }
        }
    });

    $('#bannerModal').modal('show');
};

export default home;
