const contact = () => {
    const google = window.google;
    const mapContainer = document.getElementById('map');
    if (typeof mapContainer !== 'undefined') {
        const dataMap = JSON.parse($('#map').attr('data-map-info'));
        const icon = $('#map').attr('data-icon-path');
        const map = new google.maps.Map(mapContainer, {
            center: { lat: (dataMap.lat + 0.0000400), lng: dataMap.lng },
            zoom: 15,
            styles: [{
                stylers: [{
                    saturation: -100
                }]
            }]
        });
        const marker = new google.maps.Marker({
            position: { lat: dataMap.lat, lng: dataMap.lng },
            icon,
            title:'Avian'
        });
        const contentString = `<h3>Avian</h3><br><p>${dataMap.street_name} ${dataMap.street_number}, ${dataMap.post_code}</p>`;
        const infowindow = new google.maps.InfoWindow({
            content: contentString
        });
        marker.addListener('click', function() {
            infowindow.open(map, marker);
        });

        marker.setMap(map);
    }
};

export default contact;
