<?php
//Template Name: Sales and Letting
$args  = [
    'taxonomy' => 'property-type',
    'hide_empty' => false,
];
$propertyTypes = get_terms($args);
?>
<div class="property-archive">
    <div class="banner-wrapper">
        <div class="video-poster" style="background-image: url('<?php the_post_thumbnail_url(); ?>');">
            <img class="img-responsive" itemscope="" itemtype="http://schema.org/ImageObject" src="<?php the_post_thumbnail_url(); ?>" alt="">
        </div>
        <div class="banner-overlay">
            <div class="container">
                <div class="banner-container">        
                    <?php get_template_part('templates/page', 'header'); ?>
                    <?php if (get_field('banner_caption')){ ?>
                        <div class="banner-caption"><?= get_field('banner_caption') ?: ''; ?></div>
                    <?php } ?>  
                    <?php if (get_field('banner_button_link')){ ?>
                        <a href='<?= get_field('banner_button_link');?>'><div class="btn more-info-button"><?= get_field('banner_button_text');?></div></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <div class="container post-container property-type-holder">
        <div class="row">
            <div class="col-12">
                <?php the_content(); ?>
            </div>
            <?php foreach($propertyTypes as $property) {
                $categoryImage = get_field('property_type_image' , 'property-type_' . $property->term_id) ? : get_template_directory_uri() . '/dist/images/blair-castle-default.png';
                $imageClass = get_field('property_type_image' , 'property-type_' . $property->term_id) ? 'property-type-image' : 'default-image';
                ?>
                <div class="col-md-6 col-lg-4 property-type-col">
                    <section class="property-type-section">
                        <div class="img-holder <?= $imageClass; ?>">
                            <a href="<?= get_category_link($property->term_id); ?>">
                                <img src="<?= $categoryImage; ?>" alt="<?= $property->name; ?>">
                            </a>
                        </div>
                        <h2><a href="<?= get_category_link($property->term_id); ?>"><?= $property->name; ?></a></h2>
                    </section>
                </div>
            <?php } ?>
        </div>
    </div>
</div>
