<?php
/**
 * Template Name: Long form Template
 */
?>


<?php while (have_posts()) :
    the_post(); ?>


    <?php
    if ($GLOBALS['isMobile'] == true) {
        $bannerSize = 'large';
        $bannerSizeTest = '800x520';
    } else {
        $bannerSize = 'long form banner';
        $bannerSizeTest = '1800x1000';
    }
    ?>

    <div class="post-container">
        <div class="row">

            <div class="sections">


                <div class="the-content">
                    <div class="lead-section">
                        <?php
                        $lead_banner = get_field('lead_banner_image');
                        if ($lead_banner) {
                            $lead_banner_img = wp_get_attachment_image_src($lead_banner, $bannerSize);
                            $lead_banner_url = $lead_banner_img[0];
                        } else {
                            $lead_banner_url = 'http://placehold.it/' . $bannerSizeTest . '?text=No image';
                        }
                        ?>
                        <div class="section-banner" style="background-image: url('<?php echo $lead_banner_url; ?>')">
                            <div class="container">
                                <div class="section-heading-wrapper">
                                    <h1><?php the_title(); ?></h1>
                                    <?php
                                    $value = get_field("sub_heading");
                                    if ($value) {
                                        echo '<p class="subheading">' . $value . '</p>';
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="container">
                            <div class="section-content row">
                                <div class="col-sm-4 col-lg-3 left-col left-nav">
                                    <?php
                                    $childSibMenu = B2\AthollEstatesSite::childSibMenu($post);
                                    if ($childSibMenu) {
                                        ?>
                                        <p class="dropNavTrigger"><?php _e('Other sections: '); ?><span class="fa fa-chevron-right visible-xs"></span></p>
                                        <?php echo $childSibMenu; ?>
                                    <?php } ?>

                                    <?php if (get_field('left_column')) { ?>
                                        <p><?php the_field('left_column'); ?></p>
                                    <?php } ?>
                                </div>

                                <div class="col-sm-8 col-lg-9">
                                    <?php the_content(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    // check if the repeater field has rows of data
                    if (have_rows('section')):

                    // loop through the rows of data
                    while (have_rows('section')) :
                    the_row();

                    $banner = get_sub_field('section_banner_image');
                    $aside = get_sub_field('section_aside');
                    $showAside = get_sub_field('show_aside');

                    if ($banner) {
                        $banner_img = wp_get_attachment_image_src($banner, $bannerSize);
                        $banner_url = $banner_img[0];
                    } else {
                        $banner_url = 'http://placehold.it/' . $bannerSizeTest . '?text=No image';
                        // $banner_url = 'http://lorempixel.com/'.$bannerSizeTest;
                    }
                    if (!post_password_required($post)) {

                    ?>
                    <div class="section">
                        <div class="section-banner" style='background-image: url("<?php echo $banner_url; ?>")'>

                        </div>
                        <div class="container">
                            <div class="section-content row">
                                <?php
                                if (strlen($aside) > 0 && $showAside == 1) {
                                    echo '<div class="col-sm-8 col-lg-9">';
                                } else {
                                    echo '<div class="col-sm-12 col-lg-9">';
                                }
                                echo "<h2>" . get_sub_field('section_title') . "</h2>";
                                the_sub_field('section_content');
                                if (strlen($aside) > 0 && $showAside == 1) {
                                    echo '</div><div class="aside col-sm-4 col-lg-3">' . $aside . '</div>';
                                }
                                echo '</div></div></div>'; // Close .section-content, .container and .section.
                                }
                                endwhile;
                                endif;
                                ?>
                            </div>
                        </div>
                        <?php wp_link_pages(['before' => '<nav class="page-nav"><p>' . __('Pages:', 'sage'), 'after' => '</p></nav>']); ?>
                    </div>
                    <a class="toTop smoothscroll hidden-xs" href="#"><span class="fa fa-angle-up circle-border"></span> To Top</a>
                </div>
            </div>
        </div>
    </div>
<?php endwhile; ?>