<article <?php post_class(); ?>>
    <div class="event-img col-sm-6">
        <?php
        $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "small-16x9") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "small-16x9") : array("http://placehold.it/768x500");
        $featImgAlt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
        ?>

        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
            <img class="img-responsive news-thumb" src="<?php echo $featImage[0]; ?>" alt="<?php echo $featImgAlt; ?>" title="<?php echo $featImgAlt; ?>"/>
        </a>
        <div class="dates">
            <?php
            
//            $dateStart = get_field('event_start_date', $event);
//            $dateEnd = get_field('event_end_date', $event);
             
             $dateStart = get_post_meta(get_the_ID(), 'b2_event_start_date');
            $dateEnd = get_post_meta(get_the_ID(), 'b2_event_end_date');
            
            if ($dateStart) {
                $dStart = date("d/m/Y", strtotime($dateStart[0]));
                $dateArray = explode('/', $dStart);
                $theDay = $dateArray[0];
                $theMonth = $dateArray[1];
                $dateObj = DateTime::createFromFormat('!m', $theMonth);
                $monthName = '<span>' . $dateObj->format('M') . '</span>';
                ?>
                <span class="date-circle"><?php echo $theDay . $monthName ?></span>
                <?php
            }
            if ($dateEnd && $dateEnd[0] != "19700101" && $dateEnd[0] != $dateStart[0]) {
                $dEnd = date("d/m/Y", strtotime($dateEnd[0]));
                $dateArray = explode('/', $dEnd);
                $theDay = $dateArray[0];
                $theMonth = $dateArray[1];
                $dateObj = DateTime::createFromFormat('!m', $theMonth);
                $monthName = '<span>' . $dateObj->format('M') . '</span>';
                ?>
                <span class="date-circle"><?php echo $theDay . $monthName ?></span>
                <?php
            }
            $repeats = get_field('repeats');
            if ($repeats != 'never') {
                ?>
                <span class="more-dates-circle">More dates</span>
            <?php } ?>

        </div>
    </div>
    <div class="event-text col-sm-6">
        <header>
            <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
        </header>
        <div class="entry-summary">
            <?php
            $postLink = '<a class="viewmore" href="' . get_permalink() . '">View Event </a>';
            echo wp_trim_words(get_the_excerpt(), 15, $postLink);
            ?>
        </div>

    </div>
</article>