<?php
if ($post->post_parent) {
    $ancestors = get_post_ancestors($post->ID);
    $root = count($ancestors) - 1;
    $parent = $ancestors[$root];
} else {
    $parent = $post->ID;
}
$parentSlug = get_post_field('post_name', $parent);
?>
<footer class="content-info" itemscope itemtype="http://schema.org/WPFooter">
    <div class="wrap">
        <div class="container">

            <div class="row">


                <div class="col-xs-6 col-md-5ths footer-col">
                    <a class="brand" href="<?php echo esc_url(home_url('/')); ?>">
                        <?php
                        if (get_field('site', 'options') == 'blaircastle') {
                            if ($parentSlug == 'stunning-castle-location') {
                                $logo = 'images/logos/blair-castle-and-gardens-logo.jpg';
                            } elseif ($parentSlug == 'caravan-park') {
                                $logo = 'images/logos/blair-castle-caravan-estate-logo.jpg';
                            } elseif ($parentSlug == 'corporate-hospitality') {
                                $logo = 'images/logos/corporate-hospitality-logo.jpg';
                            } elseif ($parentSlug == 'weddings-private-functions') {
                                $logo = 'images/logos/weddings-and-functions-logo.jpg';
                            } else {
                                $logo = 'images/logos/logo-blair.png';
                            }
                        } elseif (get_field('site', 'options') == 'athollestates') {
                            if ($parentSlug == 'estate-activities') {
                                $logo = 'images/logos/estate-activities.jpg';
                            } elseif ($parentSlug == 'stay-on-the-estate') {
                                $logo = 'images/logos/stay-on-the-estate-logo.jpg';
                            } else {
                                $logo = 'images/logos/logo.png';
                            }
                        }
                        ?>
                        <span itemscope itemtype="http://schema.org/ImageObject">
                            <img class = "img-responsive" itemprop="contentUrl" src = "<?php echo \Roots\Sage\Assets\asset_path($logo); ?>" alt = "<?php bloginfo('name'); ?>" title = "<?php bloginfo('name'); ?>">
                        </span>
                    </a>
                </div>
                <div class="col-xs-6 col-md-5ths footer-col">
                    <h2 class="footer-head">Contact us</h2>
                    <div class="specific-address" itemscope itemtype="http://schema.org/Organization">
                        <?php
                        if (get_field('site', 'options') == 'blaircastle') {
                            if ($parentSlug == 'caravan-park') {
                                ?>
                                <span itemprop="location" itemscope itemtype="http://schema.org/Place">
                                        <p itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">Blair Castle Caravan Park, Blair Atholl, <br/><span itemprop="addressLocality">Pitlochry</span>, <span itemprop="addressRegion">Perthshire</span> <br/><span class="postcode" itemprop="postalCode">PH18 5SR</span></p>
                                    </span>
                            <?php } else { ?>
                                <span itemprop="location" itemscope itemtype="http://schema.org/Place">
                                        <p itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">Blair Castle, Blair Atholl, <br/><span itemprop="addressLocality">Pitlochry</span>, <span itemprop="addressRegion">Perthshire</span> <br/><span class="postcode" itemprop="postalCode">PH18 5TL</span></p>
                                    </span>
                                <?php
                            }
                        } else {
                            ?>
                            <span itemprop="location" itemscope itemtype="http://schema.org/Place">
                                    <p itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">Atholl Estates Office, Blair Atholl, <br/><span itemprop="addressLocality">Pitlochry</span>, <span itemprop="addressRegion">Perthshire</span> <br/><span class="postcode" itemprop="postalCode">PH18 5TH</span></p>
                                </span>
                        <?php } ?>
                    </div>
                </div>
                <div class="col-xs-6 col-md-5ths footer-col">
                    <h2 class="footer-head">Company</h2>
                    <nav>
                        <ul id="menu-footer-left-menu" class="nav navbar-nav"><li class="menu-item menu-media"><a href="https://atholl-estates.co.uk/media-wall/">Media</a></li>
                            <li class="menu-item menu-about-atholl-estates"><a href="https://atholl-estates.co.uk/portal/about-the-estate/">About Atholl Estates</a></li>
                            <li class="menu-item menu-current-job-vacancies"><a href="https://atholl-estates.co.uk/current-vacancies/">Current Job Vacancies</a></li>
                            <li class="menu-item menu-intranet"><a href="https://atholl-estates.co.uk/intranet/">Intranet</a></li>
                            <li class="menu-item menu-pension-scheme-matters"><a href="https://atholl-estates.co.uk/pension-scheme-matters/">Pension Scheme Matters</a></li>
                        </ul>
                    </nav>
                </div>
                <div class="col-xs-6 col-md-5ths footer-col">
                    <h2 class="footer-head">Legal</h2>
                    <nav>
                        <ul id="menu-footer-left-menu" class="nav navbar-nav"><li class="menu-item menu-media"><a href="https://atholl-estates.co.uk/privacy-policy/">Privacy Policy</a></li>
                            <li class="menu-item menu-about-atholl-estates"><a href="https://atholl-estates.co.uk/cookie-policy/">Cookie Policy</a></li>
                            <li class="menu-item menu-current-job-vacancies"><a href="https://atholl-estates.co.uk/terms-conditions/">Terms & Conditions</a></li>
                        </ul>
                    </nav>
                </div>
                <div class="col-xs-6 col-md-5ths footer-col last-footer">
                    <h2 class="footer-head">Mailing list & brochure request</h2>
                    <a class="img-link mailing-list" href="https://atholl-estates.co.uk/sign-up/">
                        <p><span>Go to subscribe page</span><span class="fa fa-chevron-right"></span></p>
                    </a>
                    <p id="findus">Find Atholl Estates on social media</p>
                    <ul class="nav navbar-nav social">
                        <li><a class="f-twitter" href="https://twitter.com/Blair_Castle" target="_blank"><i class="fa fa-twitter"></i></a></li>
                        <li><a class="f-facebook" href="https://www.facebook.com/blaircastle" target="_blank"><i class="fa fa-facebook"></i></a></li>
                        <li><a class="f-youtube-play" href="https://www.youtube.com/user/AthollEstates" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
                        <li><a class="f-envelope" href="mailto:office@blair-castle.co.uk" title="Email"><i class="fa fa-envelope"></i></a></li>
                        <?php if ($parentSlug == 'scottish-highland-castle') { ?>
                            <li><a class="trip-logo-foot"
                                   href="https://www.tripadvisor.co.uk/Attraction_Review-g946548-d318884-Reviews-Blair_Castle_and_Hercules_Gardens-Blair_Atholl_Perth_and_Kinross_Scotland.html"
                                   title="Tripadvisor"><i class="fa fa-tripadvisor" aria-hidden="true"></i></a></li>
                        <?php } elseif ($parentSlug == 'caravan-estate') { ?>
                            <li><a class="trip-logo-foot"
                                   href="https://www.tripadvisor.co.uk/Hotel_Review-g946548-d1134612-Reviews-Blair_Castle_Caravan_Park-Blair_Atholl_Perth_and_Kinross_Scotland.html"
                                   title="Tripadvisor"><i class="fa fa-tripadvisor" aria-hidden="true"></i>
                                </a></li>
                        <?php } ?>
                        <li><a class="f-instagram" href="https://www.instagram.com/blair_castle_atholl_estates/" target="_blank"><i class="fa fa-instagram"></i></a></li>
                    </ul>
                </div>



                <div class="col-md-12 col-xs-6">
                    <div class="row bottom-row">
                        <div class="col-md-6 footer-info">
                            <?php dynamic_sidebar('sidebar-footer'); ?>
                            <span itemscope itemtype="http://schema.org/Organization">
                                <span itemprop="location" itemscope itemtype="http://schema.org/Place">
                                    <p itemscope itemtype="http://schema.org/PostalAddress">
                                        &copy; <span itemprop="name">Blair Castle Estate Ltd.</span></br>
                                        Atholl Estates Office, Blair Atholl, <span itemprop="addressLocality">Pitlochry</span>, <span class="postcode" itemprop="postalCode">PH18 5TH</span>
                                    </p>
                                    <p>
                                        Registration number 156776
                                    </p>
                                </span>
                            </span>
                        </div>


                        <div class="col-md-6">
                            <div class="site-by">
                                <a href="http://blue2.co.uk/" target="_blank">
                                    <p>Website by</p>
                                    <img alt="blue2" title="blue2" src="<?php echo Roots\Sage\Assets\asset_path('images/logos/blue2.png'); ?>"/>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <a href="#top" class="toTop smoothscroll col-xs-12 visible-xs">
                    <span class="fa fa-chevron-up"></span>
                    <span>Back to Top</span>
                </a>
            </div>
        </div>

</footer>

<script>
    var map,
        mapID = 'smallMap',
        myLatLng = {lat: 56.766979, lng: -3.8455785},
        mapCenter = {lat: 56.761979, lng: -3.8177785},
        mapOpts = {
            center: mapCenter,
            zoom: 7,
            scrollwheel: false,
            disableDefaultUI: true
        }

    mapID_lrg = 'largeMap';
    mapCenter_lrg = myLatLng;
    mapOpts_lrg = {
        center: mapCenter_lrg,
        zoom: 16
    };

    function initMap() {



        // Small Map
        if (document.getElementById(mapID) !== null) {
            map = new google.maps.Map(document.getElementById(mapID), mapOpts);
            // Marker
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                title: 'Blair Castle'
            });
        }


        if (document.getElementById('property-map') !== null) {
            var lat = $('#property-map').data('lat');
            var lng = $('#property-map').data('lng');

            var map = new google.maps.Map(document.getElementById('property-map'), {
                center: {lat: lat, lng: lng},
                zoom: 14
            });

            var marker = new google.maps.Marker({
                position: {lat: lat, lng: lng},
                map: map,
            });
        }

        // Large Map
        if (document.getElementById(mapID_lrg) !== null) {
            map = new google.maps.Map(document.getElementById(mapID_lrg), mapOpts_lrg);
            // Marker
            var marker = new google.maps.Marker({
                position: myLatLng,
                map: map,
                title: 'Blair Castle'
            });
        }

    }
</script>
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDjxoG7_pF4PvJhcjhcx2AhS1oEASJZdmo&libraries=places&callback=initMap" async defer></script>





