<?php
if ($post->post_parent) {
    $ancestors = get_post_ancestors($post->ID);
    $root = count($ancestors) - 1;
    $parent = $ancestors[$root];
} else {
    $parent = $post->ID;
}
$parentSlug = get_post_field('post_name', $parent);
$homeUrl = esc_url(home_url('/'));
$whatsonText = "What's On";
if (get_field('site', 'options') == 'blaircastle') {
    $logoMini = 'images/logos/blair-castle-and-gardens-logo-mini.jpg';
    if ($parentSlug == 'stunning-castle-location') {
        $logo = 'images/logos/blair-castle-and-gardens-logo.jpg';
        $logoMini = 'images/logos/blair-castle-and-gardens-logo-mini.jpg';
        $contactUrl = $homeUrl . 'stunning-castle-location/general-enquiry/';
    } elseif ($parentSlug == 'caravan-estate') {
        $logo = 'images/logos/blair-castle-caravan-estate-logo.jpg';
        $logoMini = 'images/logos/blair-castle-caravan-estate-logo-mini__NEW.jpg';
        $contactUrl = $homeUrl . 'caravan-estate/general-enquiry/';
        $whatsonText = "Online Shop";
    } elseif ($parentSlug == 'corporate-hospitality') {
        $logo = 'images/logos/corporate-hospitality-logo.jpg';
        $logoMini = 'images/logos/corporate-hospitality-logo-mini.jpg';
        $contactUrl = $homeUrl . 'corporate-hospitality/general-enquiry/';
    } elseif ($parentSlug == 'weddings-private-functions') {
        $logo = 'images/logos/weddings-and-functions-logo.jpg';
        $logoMini = 'images/logos/weddings-and-functions-logo-mini.jpg';
        $contactUrl = $homeUrl . 'weddings-private-functions/general-enquiry/';
    } else {
        $logo = 'images/logos/blair-castle-and-gardens-logo.jpg';
        $logoMini = 'images/logos/blair-castle-and-gardens-logo-mini.jpg';
        $contactUrl = $homeUrl . 'stunning-castle-location/general-enquiry/';
        $whatsonText = "Online Shop";
    }
} elseif (get_field('site', 'options') == 'athollestates') {
    $logoMini = 'images/logos/logo-mini.jpg';
    if ($parentSlug == 'estate-activities') {
        $logo = 'images/logos/estate-activities.jpg';
        $logoMini = 'images/logos/estate-activities-mini.jpg';
        $contactUrl = $homeUrl . 'estate-activities/general-enquiry/';
    } elseif ($parentSlug == 'stay-on-the-estate') {
        $logo = 'images/logos/stay-on-the-estate-logo.jpg';
        $logoMini = 'images/logos/stay-on-the-estate-logo-mini.jpg';
        $contactUrl = $homeUrl . 'stay-on-the-estate/general-enquiry/';
    } else {
        $logo = 'images/logos/logo.png';
        $logoMini = 'images/logos/logo-mini.jpg';
        $contactUrl = $homeUrl . 'contact';
    }
}

$pageSlug = get_post_field('post_name', $post->ID);

?>

<header class="banner <?= is_front_page() || $pageSlug == 'stay-on-the-estate' ? 'homepage' : ''; ?>" itemscope itemtype="http://schema.org/WPHeader">
    <div class="wrap">
        <div class="container main-nav-container">
            <div class="row">
                <nav class="nav-top">
                    <a href="#" class="fa fa-angle-down circle-border visible-xs visible-sm visible-md navTopTrigger"></a>
                    <ul id="menu-top-menu" class="nav navbar-nav">
                        <li class="menu-item menu-home"><a href="https://atholl-estates.co.uk/">Home</a></li>
                        <li class="menu-item menu-blair-castle-gardens"><a href="https://blair-castle.co.uk/">Blair Castle &amp; Gardens</a></li>
                        <li class="menu-item menu-weddings-functions"><a href="https://blair-castle.co.uk/weddings-private-functions/">Weddings &amp; Functions</a></li>
                        <li class="menu-item menu-corporate-hospitality"><a href="https://blair-castle.co.uk/corporate-hospitality/">Corporate Hospitality</a></li>
                        <li class="menu-item menu-estate-activities"><a href="https://atholl-estates.co.uk/estate-activities">Estate Activities</a></li>
                        <li class="menu-item menu-stay-on-the-estate"><a href="https://atholl-estates.co.uk/stay-on-the-estate">Stay on the Estate</a></li>
                        <li class="menu-item menu-blair-castle-caravan-park"><a href="https://blair-castle.co.uk/caravan-estate/">Blair Castle Caravan Park</a></li>
                        <!-- <li class="menu-item menu-itvs-victoria"><a href="https://atholl-estates.co.uk/special-events/">Special Events</a></li> -->
                        <li class="menu-item menu-horse-trials"><a target="_blank" href="https://www.blairhorsetrials.co.uk/">Horse Trials</a></li>
                        <?php if (get_field('show_sales_and_letting_in_top_bar', 'option')) { ?><li class="menu-item menu-sales-letting"><a target="_blank" href="<?php the_field('sales_and_letting_url', 'option'); ?>">Sales & Letting</a></li><?php } ?>
                    </ul>
                </nav>
            </div>

            <div class="row flex-row">
                <div class="col-sm-2 col-xl-2 logo-container">

                    <a class="brand" href="<?php echo $homeUrl; ?>">
                        <img class="img-responsive" src="<?php echo \Roots\Sage\Assets\asset_path($logo); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>">
                        <img class="img-responsive mini" src="<?php echo \Roots\Sage\Assets\asset_path($logoMini); ?>" alt="<?php bloginfo('name'); ?>" title="<?php bloginfo('name'); ?>">
                    </a>
                </div>
                <div class="header-links-container col-xs-12 col-sm-10 col-xl-10">
                    <div class="nav-extra">
                        <ul class="nav navbar-nav" itemscope itemtype="http://schema.org/SiteNavigationElement">
                        <?php if($whatsonText == "Online Shop") { ?>
                            <li><a href="https://www.blair-castle.shop/" title="<?= $whatsonText; ?>"><span class="hidden-sm"><?= $whatsonText; ?></span></a></li>
                        <?php } else { ?>
                            <li><a href="#collapseEvents" title="<?= $whatsonText; ?>" class="iconToggle collapsed" data-toggle="collapse" data-mobile-href="/events/"><span class="hidden-sm"><?= $whatsonText; ?></span></a></li>
                        <?php } ?>
                            <li><a href="https://atholl-estates.co.uk/media-wall" title="View our media wall"><span class="hidden-sm">Social</span></a></li>
                            <li><a href="https://atholl-estates.co.uk/latest-offers" title="View our latest offers"><span class="hidden-sm">Latest Offers</span></a></li>
                            <li><a href="<?php echo $contactUrl; ?>" title="Contact"><span class="hidden-sm">Contact</span></a></li>
                            <li class="button-item"><button type="button" class="navbar-toggle push" data-toggle="push" data-target="#mainNav" aria-expanded="false"><i class="fa fa-bars"></i></button></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="navbar-push container-fluid" id="mainNav">
            <nav class="nav-primary" itemscope itemtype="http://schema.org/SiteNavigationElement">
                <div class="tools">
                    <div class="col-xs-12 col-sm-12">
                        <ul class="nav navbar-nav social row" itemscope itemtype="http://schema.org/SiteNavigationElement">
                        <?php if ($parentSlug == 'scottish-highland-castle') { ?>
                                <li class="col-xs-6 col-md-4 no-padding-header"><a class="trip-logo" href="https://www.tripadvisor.co.uk/Attraction_Review-g946548-d318884-Reviews-Blair_Castle_and_Hercules_Gardens-Blair_Atholl_Perth_and_Kinross_Scotland.html" title="Tripadvisor"><img src="<?php echo get_template_directory_uri(); ?>/dist/images/logos/tripadvisor.png" /></a></li>
                            <?php } elseif ($parentSlug == 'caravan-estate') { ?>
                                <li class="col-xs-6 col-md-4  no-padding-header"><a class="trip-logo" href="https://www.tripadvisor.co.uk/Hotel_Review-g946548-d1134612-Reviews-Blair_Castle_Caravan_Park-Blair_Atholl_Perth_and_Kinross_Scotland.html" title="Tripadvisor"><img src="<?php echo get_template_directory_uri(); ?>/dist/images/logos/tripadvisor.png" /></a></li>
                            <?php } ?>
                            <li class="col-xs-6 col-md-4 col-lg-3 col-xl-4 menu-flex"> <?php get_search_form(); ?></li>
                            <li class="separator hidden-lg"></li>
                            <li class="menu-item ml-auto"><a href="<?php echo $homeUrl; ?>" title="Home" target="_blank"><i class="fa fa-home"></i></a></li>
                            <li><a href="https://twitter.com/Blair_Castle" target="_blank"><i class="fa fa-twitter"></i></a></li>
                            <li><a href="https://www.facebook.com/blaircastle" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            <li><a href="https://www.youtube.com/user/AthollEstates" target="_blank"><i class="fa fa-youtube-play"></i></a></li>
                            <li><a href="mailto:office@blair-castle.co.uk" title="Email"><i class="fa fa-envelope"></i></a></li>
                            <li><a href="http://atholl-estates.co.uk/sign-up/" title="Mailing list"><i class="fa fa-paper-plane"></i> <span class="hidden-xs hidden-sm">Mailing List</span></a></li>
                            <li class="separator"></li>
                            <li class="mobile-main-menu-item"><a href="/events/" title="<?= $whatsonText; ?>"><span class="hidden-lg"><?= $whatsonText; ?></span></a></li>
                            <li class="mobile-main-menu-item"><a href="https://atholl-estates.co.uk/media-wall" title="View our media wall"><span class="hidden-lg">Social</span></a></li>
                            <li class="mobile-main-menu-item"><a href="https://atholl-estates.co.uk/latest-offers" title="View our latest offers"><span class="hidden-lg">Latest Offers</span></a></li>
                            <li class="mobile-main-menu-item"><a href="<?php echo $contactUrl; ?>" title="Contact"><span class="hidden-lg">Contact</span></a></li>
                        </ul>
                    </div>                  
                    
                </div>
                <div class="col-xs-12"><div class="menu-line"></div></div>
                <div class="big-menu-box">
                    <?php
                    $parentSlug = ($parentSlug == 'caravan-park') ? 'caravan-estate' : $parentSlug;

                    $athollClass = get_field('atholl_estate_menu', 'options') ? "atholl-menu" : "";
                    if (has_nav_menu($parentSlug)) {
                        wp_nav_menu(['theme_location' => $parentSlug, 'menu_class' => 'nav navbar-nav ' . $athollClass]);
                    } elseif (has_nav_menu('primary_navigation')) {
                        wp_nav_menu(['theme_location' => 'primary_navigation', 'menu_class' => 'nav navbar-nav '. $athollClass]);
                    }
                    ?>
                    <div class="col-xs-12 col-md-4 col-xl-5 sub-menu-placeholder"></div>
                    <div class="col-xs-12 col-md-4 header-nav-events">
                        <?php
                            $hideEvents = get_field('hide_featured_event_in_menu','option');
                            if (!$hideEvents){
                                $featuredEvents = B2\AthollEstatesSite::menuFeaturedEventsBlair();
    
                                if ($featuredEvents) {
                                    if(!is_object($featuredEvents)){
                                        echo $featuredEvents;
                                    } else {
                                        echo "Events unavailable";
                                        
                                    }
                                }
                            }  
                        ?>
                    </div>
                </div>

            </nav>

        </div>
    </div>
</header>
<div class="collapse" id="collapseEvents">
    <div class="WhatsOnFeature">
        <div class="container">
            <div class="row">
                <div class="col-md-10">
                    <div class="row">
                        <?php
                        if (get_field('site', 'options') == 'athollestates') {
                            get_template_part('templates/events/header-events');
                        } else {
                            $featuredEvents = B2\AthollEstatesSite::featuredEventsBlair();

                            if ($featuredEvents) {
                                echo $featuredEvents;
                            }
                        }
                        ?>
                    </div>
                </div>
                <div class="col-sm-4 col-md-2">
                    <a class="collapse-link btn btn-cta" href="https://atholl-estates.co.uk/events/">view all events</a>
                </div>
            </div>
        </div>
    </div>
</div>