<?php
//$terms = get_terms('event-category');
$postTerm = get_the_terms(get_the_ID(), 'event-category');

$args = array(
    'posts_per_page' => -1,
    'meta_key' => 'b2_event_start_date',
    'orderby' => 'meta_value_num',
    'post_type' => 'event',
    'order' => 'ASC',
    'meta_query' => array(
        'relation' => 'OR',
        array(
            'key' => 'b2_event_start_date',
            'value' => date('Ymd'),
            'compare' => '>='
        ),
        array(
            'key' => 'b2_event_end_date',
            'value' => date('Ymd'),
            'compare' => '>='
        )
    ),
);
$events = new WP_Query($args);

$list = wp_list_pluck($events->posts, 'ID');
$terms = wp_get_object_terms($list, 'event-category');
?>

<div class="container post-container category-<?php echo strtolower($postTerm[0]->slug); ?>" itemscope itemtype="http://schema.org/Event">
    <div class="row">

        <header>
            <h1 class="entry-title" itemprop="name"><?php the_title(); ?></h1>
            <?php if (get_field('booking_link')) { ?>
                <a itemprop="url" class="btn btn-cta events-bookingbtn" href="<?php the_field('booking_link'); ?>">Book now</a>
            <?php } ?>
        </header>

        <div class="col-xs-12 col-sm-4 col-lg-3 left-col">
            <p class="dropNavTrigger">Events by Category<span class="fa fa-chevron-right visible-xs"></span></p>
            <div class="nav">
                <ul>
                    <li><a href="/events">All <strong>(<?php echo $events->post_count; ?>)</strong></a></li>

                    <?php
                    foreach ($terms as $term) {
                        $termLink = get_term_link($term);
                        ?>
                                                                                                                                                                                        <!--<li><a href="<?php // echo $termLink;                                         ?>"><?php // echo $term->name;                                         ?></a></li>-->
                        <li data-filter="<?php echo '.filter-' . $term->slug; ?>"><a href="/events"><?php echo $term->name; ?></a></li>

                    <?php } ?>
                </ul>
            </div>

            <div class="event-schedule">
                <?php the_field('left_content'); ?>
            </div> 

            <p class="text-center"><a class="btn btn-default" href="<?php echo get_bloginfo('url'); ?>/events">Return to All Events</a></p>
        </div>

        <div class="col-xs-12 col-sm-8 col-lg-9">
            <div class="dates">
                <?php
//                $dateStart = get_field('event_start_date');
//                $dateEnd = get_field('event_end_date'); 
                $dateStart = get_post_meta(get_the_ID(), 'b2_event_start_date');
                $dateEnd = get_post_meta(get_the_ID(), 'b2_event_end_date');


                if ($dateStart) {
                            $dStart = date("d/m/Y", strtotime($dateStart[0]));
                            $dateArray = explode('/', $dStart);
                            $theDay = $dateArray[0];
                            $theMonth = $dateArray[1];
                            $dateObj = DateTime::createFromFormat('!m', $theMonth);
                            $monthName = '<span>' . $dateObj->format('M') . '</span>';
                            ?>
                            <span class="date-circle" itemprop="startDate"><?php echo $theDay . $monthName ?></span>
                            <?php
                        }
                        if ($dateEnd && $dateEnd[0] != "19700101" && $dateEnd[0] != $dateStart[0]) {
                            $dEnd = date("d/m/Y", strtotime($dateEnd[0]));
                            $dateArray = explode('/', $dEnd);
                            $theDay = $dateArray[0];
                            $theMonth = $dateArray[1];
                            $dateObj = DateTime::createFromFormat('!m', $theMonth);
                            $monthName = '<span>' . $dateObj->format('M') . '</span>';
                            ?>
                            <span class="date-circle" itemprop="endDate"><?php echo $theDay . $monthName ?></span>
                            <?php
                        }
                
                $np=get_next_post();
                if (!empty( $np )){ ?>
                    <a href="<?php echo get_permalink( $np->ID ); ?>" class="viewmore">Next Event</a>
                <?php }
               
                //next_post_link('%link', 'Next Event >>');
               
                $repeats = get_field('repeats');
                if ($repeats != 'never') {
                    ?>
                    <!--<nav class="nav-primary">-->
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">More Dates Available
                            <span class="caret"></span></button>
                        <ul class="dropdown-menu">

                            <?php
                            $datesArray = get_post_meta(get_the_ID(), 'b2_event_dates');

                            if ($datesArray) {
                                $count = 1;
                                $now = strtotime(date('Ymd'));
                                foreach ($datesArray[0] as $day) {
                                    if (( strtotime($day['start']) >= $now || strtotime($day['start']) < $now && strtotime($day['finish']) > $now ) && $count == 1) {
                                        $count++;
                                        $printDate = $day['finish'] && $day['finish'] != "19700101" ? date('d M', strtotime($day['start'])) . " - " . date('d M', strtotime($day['finish'])) : date('d M', strtotime($day['start']));
                                        ?>
                                        <li class = ""><a href='#'><strong><?php echo $printDate; ?></strong></a></li>
                                        <?php
                                    } else {
                                        $printDate = $day['finish'] && $day['finish'] != "19700101" ? date('d M', strtotime($day['start'])) . " - " . date('d M', strtotime($day['finish'])) : date('d M', strtotime($day['start']));
                                        ?>
                                        <li class = ""><a href='#'><?php echo $printDate; ?></a></li>
                                        <?php
                                    }
                                }
                            }
                            ?>

                        </ul>
                    </div>
                    <!--</nav>-->
                <?php } ?>

            </div>

            <?php
            $featImage = wp_get_attachment_image_src(get_post_thumbnail_id(), "header image") ? wp_get_attachment_image_src(get_post_thumbnail_id(), "header image") : array("https://dummyimage.com/1920x1000/cccccc/000000.jpg&text=Pending+");
            $featImgAlt = get_post_meta(get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
            ?>
            <img class="img-responsive featured-img" itemscope itemtype="http://schema.org/ImageObject" itemprop="contentUrl" src="<?php echo $featImage[0]; ?>" alt="<?php echo $featImgAlt; ?>" title="<?php echo $featImgAlt; ?>"/>

            <div class="the-content cms">

                <article <?php post_class(); ?>>

                    <div class="entry-content" itemprop="text">
                        <?php the_content(); ?>

                        <div class="event-cta-buttons">
                            <a class="btn btn-default" href="/events">Other Events</a>
                            <?php if (get_field('booking_link')) { ?>
                                <a itemprop="url" class="btn btn-cta" href="<?php the_field('booking_link'); ?>">Book now</a>
                            <?php } ?>
                        </div>
                    </div>

                </article>



            </div>
        </div>

    </div>
</div>