<?php
/**
 * Template Name: Blair Castle home page
 */
the_content();
if (!post_password_required($post)) { ?>
    <div class="banner-wrapper">
        <?php
        $bannerMedia = get_field('banner_media');
        if ($bannerMedia == 'image') {
            get_template_part('templates/image/image-banner');
        } elseif ($bannerMedia == 'slider') {
            get_template_part('templates/slider/slider-banner');
            ?>

            <?php
        } elseif ($bannerMedia == 'video') {
            while (have_rows('banner_video_repeater')) {
                the_row();
                get_template_part('templates/video/video-banner');
            }
        }
        ?>
        <div class="banner-overlay">
            <div class="container">
                <div class="banner-container">        
                    <?php get_template_part('templates/page', 'header'); ?>
                    <?php if (get_field('banner_caption')){ ?>
                        <div class="banner-caption"><?= get_field('banner_caption') ?: ''; ?></div>
                    <?php } ?>                    
                    <?php if (get_field('banner_button_link')){ ?>
                        <a href='<?= get_field('banner_button_link');?>'><div class="btn more-info-button"><?= get_field('banner_button_text');?></div></a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container post-container">
        <div class="row bordered-row no-border">
            <?php
            if (have_rows('big_panels')) {
                while (have_rows('big_panels')) {
                    the_row();
                    $panelMedia = get_sub_field('big_panel_media');
                    if ($panelMedia == 'image') {
                        get_template_part('templates/image/image-hw-panel');
                    } elseif ($panelMedia == 'slider') {
                        get_template_part('templates/slider/slider-hw-panel');
                    } elseif ($panelMedia == 'video') {
                        get_template_part('templates/video/video-hw-panel');
                    } elseif ($panelMedia == 'wygiwyg') {
                        get_template_part('templates/content/wygiwyg-hw-panel');
                    }
                }
            }

            if (have_rows('related_pages')) {
                get_template_part('templates/feature/feature-square-row');
            }
            ?>


            <div class="feature-box col-xs-12 col-md-4">
                <?php the_field('left_content'); ?>
            </div>
            <div class="feature-box latest-news col-xs-12 col-md-4">
                <h3>Latest News</h3>
                <?php
                if (get_field('site', 'options') == 'athollestates') {
                    get_template_part('templates/news/latest-news');
                } else {
                    $latestNews = B2\AthollEstatesSite::latestNewsBlair();

                    if ($latestNews) {
                        echo $latestNews;
                    }
                }
                ?>
            </div>

            <div class="feature-box col-xs-12 col-sm-6 col-md-4">
                <?php the_field('right_content'); ?>
            </div>
        </div>
    </div>

    <?php get_template_part('templates/panels/fw-panel'); ?>


<?php } ?>