<?php
while (have_posts()) {
    the_post();
    ?>
    <div class="container post-container">
        <?php get_template_part('templates/page-header'); ?>
        <div class="row">
            <?php
            $childSibMenu = B2\AthollEstatesSite::childSibMenu($post);
            if ($childSibMenu || get_field('google_maps') || get_field('tripadvisor')) {
                if (!post_password_required($post)) {

                    ?>
                    <div class="col-xs-12 col-sm-4 left-col-nav left-nav">
                        <?php
                        if ($childSibMenu) {
                            ?>
                            <p class="dropNavTrigger"><?php _e('In this section'); ?><span class="fa fa-chevron-right visible-xs"></span></p>
                            <?php
                            if (is_page('media-wall')) {
                                wp_nav_menu(array('theme_location' => 'media_wall', 'menu_class' => 'nav navbar-nav'));
                            } else {
                                echo $childSibMenu;
                            }
                        }
                        ?>
                        <div class="blockswrapper">
                            <div class="blockscontent">
                                <?php
                                if (get_field('left_column')) {
                                    echo '<div class="block cms">';
                                    the_field('left_column');
                                    echo '</div>';
                                }
                                if (get_field('google_maps')) {
                                    get_template_part('templates/feature/google-maps');
                                }

                                if (get_field('tripadvisor')) {
                                    if (get_field('trip_advisor_setting') == 'Blair Castle and Hercules Gardens') {
                                        get_template_part('templates/feature/tripadvisor-castle');
                                    } elseif (get_field('trip_advisor_setting') == 'Blair Castle Caravan Park') {
                                        get_template_part('templates/feature/tripadvisor-caravan-park');
                                    } else {
                                        get_template_part('templates/feature/tripadvisor-castle');
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                <?php } ?>
                <div class="col-xs-12 col-sm-8 default-page">
                    <?php get_template_part('templates/content', 'page'); ?>
                </div>
                <div class="blockswrappermobile">
                </div>
            <?php } else { ?>
                <div class="col-xs-12 col-sm-12 default-page">
                    <?php get_template_part('templates/content', 'page'); ?>
                </div>
            <?php } ?>


        </div>
    </div>

<?php } ?>