<?php
/**
 * Template Name: Special Events Template
 */
?>
<div class="container">
    <?php

    use Roots\Sage\Titles; ?>
    <div class="page-header">
        <h1>What's On</h1>
        <p class="subheading">Special Events at Blair Castle</p>
    </div>
</div>


<?php
$args = array(
    'posts_per_page' => -1,
    'meta_key' => 'b2_event_start_date',
    'orderby' => 'meta_value_num',
    'post_type' => 'event',
    'tax_query' => array(
        array(
            'taxonomy' => 'event-category',
            'field'    => 'slug',
            'terms'    => 'special-event',
        ),
    ),
    'order' => 'ASC',
    'meta_query' => array(
        'relation' => 'OR',
        array(
            'key' => 'b2_event_start_date',
            'value' => date('Ymd'),
            'compare' => '>='
        ),
        array(
            'key' => 'b2_event_end_date',
            'value' => date('Ymd'),
            'compare' => '>='
        )
    ),
);
$events = new WP_Query($args);
?>
<div class="container post-container">
    <div class="row bordered-row">
        <div class="events-col " id="mixContainer">
            <?php if (!$events->have_posts()) { ?>
                <div class="alert alert-warning">
                    <?php _e('Sorry, no results were found.', 'sage'); ?>
                </div>
                <?php get_search_form(); ?>
            <?php } ?>
            <?php
            while ($events->have_posts()) {
                $events->the_post();
                ?>
                <?php
                $cats = ''; //strtolower(wp_strip_all_tags(get_the_category_list(' ')));
                foreach (wp_get_post_terms($post->ID, 'event-category') as $category) {
                    $cats .= 'filter-' . $category->slug . ' ';
                }
                ?>
                <div class="event-container col-sm-6 mix <?php echo $cats; ?>" data-mh="event-group">
                    <?php get_template_part('templates/content', 'archive-event'); ?>
                </div>
            <?php } ?>
        </div>

        <?php // the_posts_navigation();       ?>

    </div>
</div>