<?php
/**
 * Template Name: Portal home page template
 */
?>

<?php
the_content();
if (!post_password_required($post)) {

    $bannerBGImage = get_field('banner_background_image');
    $bannerBGImage = $bannerBGImage ? wp_get_attachment_image_src($bannerBGImage, "long form banner") : array("https://dummyimage.com/1920x1000/cccccc/000000.jpg&text=Pending+");
    ?>
    <div class="video-poster" style="background-image: url(<?php echo $bannerBGImage[0]; ?>);">
        <img class="img-responsive" src="<?php echo $bannerBGImage[0]; ?>" alt="">
    </div>
    <div class="container post-container portal">
        <div class="banner-boxes">
            <?php
            while (have_rows('banner_boxes')) {
                the_row();
                $boxImg = get_sub_field('box_image');
                $boxImgAlt = get_post_meta($boxImg, '_wp_attachment_image_alt', true);
                $boxImg = $boxImg ? wp_get_attachment_image_src($boxImg, "small-4x3") : array("https://dummyimage.com/480x340/cccccc/000000.jpg&text=Pending+");
                $rowType = 'banner_boxes';
                ?>
                <div class="feature-box col-xs-6 col-md-2">
                    <div>
                        <?php $link = get_sub_field('link_type'); ?>
                        <a href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>">
                            <img class="img-responsive" src="<?php echo $boxImg[0]; ?>" alt="<?php echo $boxImgAlt; ?>" title="<?php echo $boxImgAlt; ?>"/>
                            <h2><?php the_sub_field('box_title'); ?></h2>
                        </a>

                    </div>
                </div>
            <?php } ?>
        </div>
    </div>

    <?php
    $count = 0;
    while (have_rows('panels')) {
        the_row();
        $panelImage = get_sub_field('panel_image');
        $panelImgAlt = get_post_meta($panelImage, '_wp_attachment_image_alt', true);
        $panelImage = $panelImage ? wp_get_attachment_image_src($panelImage, "small-4x3") : array("https://dummyimage.com/630x435/cccccc/000000.jpg&text=Pending+");
        $count++;
        $rowType = 'panels';
        $link = get_sub_field('link_type');

        if ($count == 1) {
            ?>
            <section class="feature-panel">
                <div class="feature-details">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6 hidden-xs">
                                <a href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>">
                                    <img class="img-responsive" src="<?php echo $panelImage[0]; ?>" alt="<?php echo $panelImgAlt; ?>" title="<?php echo $panelImgAlt; ?>"/>
                                </a>
                            </div>
                            <div class="col-sm-6">
                                <h2><a href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>"><?php the_sub_field('panel_title'); ?></a></h2>
                                <img class="img-responsive visible-xs" src="<?php echo $panelImage[0]; ?>" alt="<?php echo $panelImgAlt; ?>" title="<?php echo $panelImgAlt; ?>"/>
                                <p class="padding-top">
                                    <?php echo get_sub_field('panel_content',false, false); ?>
                                    <a class="btn btn-icon" href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>"><span class="fa fa-angle-right"> </span></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="lower-panels">
            <div class="container">
            <div class="row bordered-row">
            <?php
        } else {
            $colSize = $count == 2 || $count == 3 ? "col-sm-6" : "col-sm-4";
            ?>
            <div class="<?php echo $colSize; ?>">
                <h2><a href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>"><?php the_sub_field('panel_title'); ?></a></h2>
                <a href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>">
                    <img class="img-responsive" src="<?php echo $panelImage[0]; ?>" alt="<?php echo $panelImgAlt; ?>" title="<?php echo $panelImgAlt; ?>"/>
                </a>
                <p>
                    <?php echo wp_trim_words(get_sub_field('panel_content'), 50, '..'); ?>
                    <a class="btn btn-icon" href="<?= B2\AthollEstatesSite::returnLinkType($link, $rowType) ?>"><span class="fa fa-angle-right"> </span></a>
                </p>
            </div>
            <?php
        }
    }
    ?>
    </div>
    </div>
    </section>
<?php } ?>
